/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.fields;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;

public final class TopFrameField
extends Field {
    private final IField m_field;

    public TopFrameField(IEventType type, String attributIdentifier, IField field) {
        super(type, "(" + attributIdentifier + ".frame)");
        this.m_field = field;
        this.setName("Stacktrace (Top Frame)");
        this.setDescription("The frame on top of the stack");
        this.setFieldType(FieldType.OBJECT);
        this.setContentType(UnitLookup.METHOD.getIdentifier());
        this.setVisible(false);
        this.setSynthetic(true);
    }

    @Override
    public Object getValue(IEvent event) {
        Object o = this.m_field.getValue(event);
        if (o instanceof FLRStackTrace) {
            return ((FLRStackTrace)o).getValidTopFrame();
        }
        return null;
    }
}

