/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class StringBrowseInput
extends Input {
    private static final int BROWSE_BUTTON_WIDTH = 2;
    private Text m_text;
    private Button m_browseButton;
    private ControlDecoration m_controlDecoration;
    private boolean m_mustSelect = true;

    public StringBrowseInput(String property, String name) {
        super(property, name);
    }

    final void setMustSelect(boolean mustSelect) {
        this.m_mustSelect = mustSelect;
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        GridData gd1 = new GridData(4, 4, false, false);
        gd1.verticalAlignment = 0x1000000;
        gd1.horizontalSpan = 1;
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.verticalAlignment = 0x1000000;
        gd2.horizontalSpan = horizontalSpan - 2 - 1;
        this.m_text = new Text(parent, 2056);
        this.m_text.setText("");
        this.m_text.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        gd3.horizontalSpan = 2;
        this.m_browseButton = this.createBrowseButton(parent);
        this.m_browseButton.setText(Messages.STRING_BROWSE_INPUT_SELECT_BUTTON_TEXT);
        this.m_browseButton.setLayoutData((Object)gd3);
        this.m_controlDecoration = new ControlDecoration((Control)this.m_browseButton, 131072);
        this.m_controlDecoration.setImage(UIPlugin.getDefault().getImage("error_obj.gif"));
        this.m_controlDecoration.hide();
    }

    private Button createBrowseButton(final Composite parent) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StringBrowseInput.this.browse(parent.getShell())) {
                    StringBrowseInput.this.markStale();
                }
            }
        });
        return button;
    }

    @Override
    public IStatus getStatus() {
        if (this.getPropertyValue().trim().length() == 0 && this.m_mustSelect) {
            return new Status(4, "com.jrockit.mc.components.ui", Messages.STRING_BROWSE_INPUT_MUST_SELECT_TEXT);
        }
        return new Status(0, "com.jrockit.mc.components.ui", Messages.STRING_BROWSE_INPUT_VALID_VALUE_TEXT);
    }

    protected abstract boolean browse(Shell var1);

    private void updateControlDecoration() {
        IStatus status = this.getStatus();
        if (status.getSeverity() == 0 || status.getSeverity() == 1) {
            this.getControlDecoration().setDescriptionText(null);
            this.getControlDecoration().hide();
        } else {
            if (status.getSeverity() == 2) {
                this.getControlDecoration().setImage(UIPlugin.getDefault().getImage("alert_obj.png"));
                this.getControlDecoration().setDescriptionText(status.getMessage());
                this.getControlDecoration().show();
            }
            if (status.getSeverity() == 4) {
                this.getControlDecoration().setImage(UIPlugin.getDefault().getImage("error_obj.gif"));
                this.getControlDecoration().setDescriptionText(status.getMessage());
                this.getControlDecoration().show();
            }
        }
    }

    private ControlDecoration getControlDecoration() {
        return this.m_controlDecoration;
    }

    @Override
    public void refresh() {
        if (this.isEnabled()) {
            this.updateControlDecoration();
            String p = this.getPropertyValue();
            if (!this.m_text.getText().equals(p)) {
                this.m_text.setText(this.getPropertyValue());
            }
        } else {
            this.m_text.setText("");
        }
    }
}

