/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.internal.AbstractConverter;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateConverter
extends AbstractConverter<Date> {
    private static final SimpleDateFormat ISO_LIKE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private static final SimpleDateFormat ISO_STRICT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private static final SimpleDateFormat TO_STRING_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    private static final SimpleDateFormat[] CONFIG_PARSERS = new SimpleDateFormat[]{ISO_LIKE_FORMAT, TO_STRING_FORMAT, ISO_STRICT_FORMAT};
    private static final SimpleDateFormat[] HUMAN_PARSERS = new SimpleDateFormat[]{ISO_LIKE_FORMAT, TO_STRING_FORMAT, ISO_STRICT_FORMAT, new SimpleDateFormat()};

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    public Date fromHuman(String humanString) throws QuantityConversionException {
        return this.parseUsingAny(humanString, HUMAN_PARSERS);
    }

    @Override
    public Date toServerValue(String configString) throws QuantityConversionException {
        return this.parseUsingAny(configString, CONFIG_PARSERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseUsingAny(String stringValue, SimpleDateFormat[] parsers) throws QuantityConversionException {
        SimpleDateFormat[] simpleDateFormatArray = parsers;
        int n = parsers.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleDateFormat element = simpleDateFormatArray[n2];
            try {
                Class<DateConverter> clazz = DateConverter.class;
                synchronized (DateConverter.class) {
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return element.parse(stringValue);
                }
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw ConversionException.unparsable(stringValue, this, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toConfigString(Date serverValue) {
        Class<DateConverter> clazz = DateConverter.class;
        synchronized (DateConverter.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ISO_LIKE_FORMAT.format(serverValue);
        }
    }
}

