/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JFRRepository
extends VMObject {
    private static AddressField repositoryField;
    private static Field repositoryLenField;
    private static AddressField chunkPathField;
    private static AddressField chunkPathPartField;

    public JFRRepository(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrRepository");
        repositoryField = type.getAddressField("_repository");
        repositoryLenField = type.getAddressField("_repository_len");
        chunkPathField = type.getAddressField("_chunk_path");
        chunkPathPartField = type.getAddressField("_chunk_path_part");
    }

    public String getRepository() {
        int repo_len = this.getRepositoryLength();
        char[] repository = new char[repo_len];
        Address repositoryAddress = repositoryField.getValue(this.addr);
        if (repositoryAddress == null) {
            return null;
        }
        for (int i = 0; i < repo_len; ++i) {
            repository[i] = (char)repositoryAddress.getJByteAt(i);
        }
        return new String(repository);
    }

    public int getRepositoryLength() {
        return repositoryLenField.getJInt(this.addr);
    }

    public String getChunkPath() {
        Address chunkPathAddress = chunkPathField.getValue(this.addr);
        if (chunkPathAddress == null) {
            return null;
        }
        StringBuffer chunk_path = new StringBuffer();
        int i = 0;
        char c = (char)chunkPathAddress.getJByteAt(i);
        while (c != '\u0000') {
            chunk_path.append(c);
            c = (char)chunkPathAddress.getJByteAt(++i);
        }
        return new String(chunk_path);
    }

    public String getChunkPathPart() {
        Address chunkPathPartAddress = chunkPathPartField.getValue(this.addr);
        if (chunkPathPartAddress == null) {
            return null;
        }
        StringBuffer chunk_path_part = new StringBuffer();
        int i = 0;
        char c = (char)chunkPathPartAddress.getJByteAt(i);
        while (c != '\u0000') {
            chunk_path_part.append(c);
            c = (char)chunkPathPartAddress.getJByteAt(++i);
        }
        return new String(chunk_path_part);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRRepository.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

