/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.ppc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.ppc.LinuxPPCCFrame;
import sun.jvm.hotspot.debugger.ppc.PPCThreadContext;

public class LinuxPPCThreadContext
extends PPCThreadContext {
    private LinuxDebugger debugger;

    public LinuxPPCThreadContext(LinuxDebugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public void setRegisterAsAddress(int index, Address value) {
        this.setRegister(index, this.debugger.getAddressValue(value));
    }

    @Override
    public Address getRegisterAsAddress(int index) {
        return this.debugger.newAddress(this.getRegister(index));
    }

    @Override
    public LinuxPPCCFrame getTopFrame(Debugger dbg) {
        Address sp = this.getRegisterAsAddress(1);
        if (sp == null) {
            return null;
        }
        Address pc = this.getRegisterAsAddress(36);
        if (pc == null) {
            return null;
        }
        return new LinuxPPCCFrame((LinuxDebugger)dbg, sp, pc);
    }
}

