/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Log {
    private static Logger delegate = null;
    private static boolean debug = "true".equals(System.getenv("JAVAFX_ANT_DEBUG"));

    public static void setLogger(Logger logger) {
        delegate = logger;
        if (logger == null) {
            delegate = new Logger(false);
        }
    }

    public static void info(String string) {
        if (delegate != null) {
            delegate.info(string);
        }
    }

    public static void verbose(String string) {
        if (delegate != null) {
            delegate.verbose(string);
        }
    }

    public static void verbose(Throwable throwable) {
        if (delegate != null) {
            delegate.verbose(throwable);
        }
    }

    public static void debug(String string) {
        if (delegate != null) {
            delegate.debug(string);
        }
    }

    public static void debug(RuntimeException runtimeException) {
        Log.debug((Throwable)runtimeException);
    }

    public static void debug(Throwable throwable) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (PrintStream printStream = new PrintStream(byteArrayOutputStream);){
                throwable.printStackTrace(printStream);
            }
            Log.debug(byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static class Logger {
        private boolean verbose = false;

        public Logger(boolean bl) {
            this.verbose = bl;
        }

        public void info(String string) {
            System.out.println(string);
        }

        public void verbose(Throwable throwable) {
            if (debug || this.verbose) {
                throwable.printStackTrace(System.out);
            }
        }

        public void verbose(String string) {
            if (debug || this.verbose) {
                System.out.println(string);
            }
        }

        public void debug(String string) {
            if (debug) {
                System.out.println(string);
            }
        }
    }
}

