/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.commands.internal.parser;

import com.jrockit.mc.commands.Parameter;
import com.jrockit.mc.commands.internal.parser.ParameterParser;
import com.jrockit.mc.commands.internal.parser.ParserException;
import com.jrockit.mc.common.parsing.Token;
import java.text.ParseException;

final class NumberParser
extends ParameterParser {
    public static final String ID = "number";

    public NumberParser(Parameter parameter) {
        super(parameter);
    }

    @Override
    boolean acceptValue(String text) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException pe) {
            return false;
        }
    }

    @Override
    protected Object parseValue(Token parameterToken, String text) throws ParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Not a valid number.", parameterToken);
        }
    }
}

