/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.environment;

import java.io.File;

public class OS {
    private static final String s_fullName = System.getProperty("os.name");
    private static final Type s_type = OS.determineType(OS.getFullName());
    private static final boolean s_couldbeUsingGTK = File.separatorChar == '/' && OS.getType() != Type.MAC;

    public static boolean couldBeUsingGTK() {
        return s_couldbeUsingGTK;
    }

    public static String getFullName() {
        return s_fullName;
    }

    public static Type getType() {
        return s_type;
    }

    public static Type getTypeFromString(String name) {
        return OS.determineType(name);
    }

    private static Type determineType(String os) {
        if (os == null) {
            return Type.UNKNOWN;
        }
        if ((os = os.toLowerCase()).contains("win")) {
            return Type.WINDOWS;
        }
        if (os.contains("mac")) {
            return Type.MAC;
        }
        if (os.contains("sunos")) {
            return Type.SOLARIS;
        }
        if (os.contains("linux")) {
            return Type.LINUX;
        }
        if (os.contains("nix") || os.contains("nux")) {
            return Type.UNKNOWN_UNIX;
        }
        return Type.UNKNOWN;
    }

    public static enum Type {
        WINDOWS,
        MAC,
        SOLARIS,
        LINUX,
        UNKNOWN_UNIX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

