/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.designelement;

import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.designelement.RootElement;
import com.jrockit.mc.components.ui.design.menus.DesignMenu;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;

final class MouseElementListener {
    private static int LEFT_MOUSE_BUTTON = 1;
    private final IDesignElement m_designElement;

    public MouseElementListener(IDesignElement element) {
        this.m_designElement = element;
        this.m_designElement.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == LEFT_MOUSE_BUTTON && (e.stateMask & SWT.MOD4) == 0) {
                    MouseElementListener.this.onClickLeft();
                }
            }
        });
        this.m_designElement.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                MouseElementListener.this.onContextMenu();
            }
        });
    }

    protected final LayoutItem getLayoutItem() {
        return this.m_designElement.getLayoutItem();
    }

    private IDesignElement getActiveDesignElement() {
        IDesignElement item = this.m_designElement;
        while (item != null) {
            if (this.m_designElement.isSelected()) {
                return item;
            }
            item = item.getParentElement();
        }
        return null;
    }

    private void onClickLeft() {
        this.m_designElement.getControl().forceFocus();
        this.m_designElement.setSelected();
    }

    private void onContextMenu() {
        if (!this.m_designElement.isSelected()) {
            this.m_designElement.setSelected();
        }
        DesignMenu.show((Control)this.m_designElement.getControl(), this.getActiveDesignElement(), this.getServiceLocator());
    }

    private IServiceLocator getServiceLocator() {
        return this.m_designElement.getServiceLocator();
    }

    public IDesignElement getParentToSelect(IDesignElement element) {
        if (!(element.getParentElement() instanceof RootElement)) {
            if (element.isSelected()) {
                return element.getParentElement();
            }
            return this.getParentToSelect(element.getParentElement());
        }
        return null;
    }
}

