/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.common.DataSeries;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDataSeries;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import se.hirt.greychart.SeriesMetaDataProvider;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.RenderingMode;

class FlrSeriesMetaDataProvider
implements SeriesMetaDataProvider {
    private final XAxisDescriptor xAxis;
    private final Set<DataSeriesDescriptor> leftSeries;
    private final YAxis leftYAxis;
    private final YAxis rightYAxis;

    FlrSeriesMetaDataProvider(FLRChartDescriptor chartDescriptor, YAxis leftYAxis, YAxis rightYAxis) {
        this.leftYAxis = leftYAxis;
        this.rightYAxis = rightYAxis;
        this.xAxis = chartDescriptor.getXAxis();
        this.leftSeries = new HashSet<DataSeriesDescriptor>(chartDescriptor.getLeftYAxis().getDataSeries());
    }

    public boolean getDrawLine(DataSeries<?> ds) {
        return FlrSeriesMetaDataProvider.getDescriptor(ds).getDrawLine();
    }

    public Color getLineColor(DataSeries<?> ds) {
        return FlrSeriesMetaDataProvider.getDescriptor(ds).getLineColor().getAWTColor();
    }

    public Color getTopColor(DataSeries<?> ds) {
        DataSeriesDescriptor dsd = FlrSeriesMetaDataProvider.getDescriptor(ds);
        return dsd.getFilled() ? dsd.getTopColor().getAWTColor() : null;
    }

    public Color getBottomColor(DataSeries<?> ds) {
        DataSeriesDescriptor dsd = FlrSeriesMetaDataProvider.getDescriptor(ds);
        return dsd.getFilled() ? dsd.getBottomColor().getAWTColor() : null;
    }

    public boolean getFill(DataSeries<?> ds) {
        return FlrSeriesMetaDataProvider.getDescriptor(ds).getFilled();
    }

    public boolean getStacking(DataSeries<?> ds) {
        return FlrSeriesMetaDataProvider.getDescriptor(ds).getStack();
    }

    public RenderingMode getMode(DataSeries<?> ds) {
        return ChartModelBuilder.getGraphConfig((XAxisDescriptor)this.xAxis, (DataSeriesDescriptor)FlrSeriesMetaDataProvider.getDescriptor(ds)).renderingMode;
    }

    public YAxis getYAxis(DataSeries<?> ds) {
        return this.leftSeries.contains(FlrSeriesMetaDataProvider.getDescriptor(ds)) ? this.leftYAxis : this.rightYAxis;
    }

    private static DataSeriesDescriptor getDescriptor(DataSeries<?> ds) {
        return ((FLRDataSeries)ds).getDescriptor();
    }

    public double getOffset(DataSeries<?> ds) {
        return 0.0;
    }

    public double getMultiplier(DataSeries<?> ds) {
        return 1.0;
    }
}

