/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.util.AndFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class GraphEvents
implements Iterable<IEvent> {
    private final FlightRecording m_recording;
    private final IEventFilter m_filter;

    GraphEvents(IEventFilter filter, FlightRecording flightRecording) {
        this.m_recording = flightRecording;
        this.m_filter = filter;
    }

    @Override
    public Iterator<IEvent> iterator() {
        IView view = this.m_recording.createView();
        view.setFilter((IEventFilter)new AndFilter((IEventFilter)new GraphSelectionFilter(), this.m_filter));
        view.setEventTypes(this.createVisibleEventTypeSet());
        view.setOrder(EventOrder.ANY);
        view.setExpansion(Expansion.NORMAL);
        return view.iterator();
    }

    private Collection<IEventType> createVisibleEventTypeSet() {
        ArrayList<IEventType> types = new ArrayList<IEventType>();
        for (IEventType type : this.m_recording.getEventTypes()) {
            if (!EventToolkit.isVisible(type)) continue;
            types.add(type);
        }
        return types;
    }

    static class GraphSelectionFilter
    implements IEventFilter {
        GraphSelectionFilter() {
        }

        public boolean accept(IEvent event) {
            return EventToolkit.isPartOfGraphSelecion(event);
        }
    }
}

