/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponents;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class UIComponentBuilder {
    public static final Object THREAD = "platformId";
    private final FlightRecording m_recording;

    public UIComponentBuilder(FlightRecording recording) {
        this.m_recording = recording;
    }

    private void addThreads(UIComponents uiComponents) {
        ArrayList<UIThreadGroup> groups = new ArrayList<UIThreadGroup>();
        ArrayList<UIThread> threads = new ArrayList<UIThread>();
        ITrackGroup threadSystem = this.m_recording.getRootGroup().getGroup("threadEvents");
        if (threadSystem != null) {
            for (ITrackGroup threadGroup : threadSystem.getGroups()) {
                UIThreadGroup uig = new UIThreadGroup(threadGroup.getName());
                groups.add(uig);
                for (ITrackGroup thread : threadGroup.getGroups()) {
                    IMCThread flrThread = (IMCThread)thread.getProperty("thread");
                    if (flrThread == null) continue;
                    UIThread uiThread = new UIThread(flrThread, thread);
                    uig.addThread(uiThread);
                    ArrayList<UITrack> uiTracks = new ArrayList<UITrack>();
                    for (ITrack lane : thread.getTracks()) {
                        ArrayList<ITrack> lanes = new ArrayList<ITrack>();
                        lanes.add(lane);
                        uiTracks.add(new UITrack(this.m_recording, lanes, lane.getName(), Color.RED));
                    }
                    uiThread.addTracks(uiTracks);
                }
            }
        }
        uiComponents.setThreadGroups(groups);
        uiComponents.setThreads(threads);
    }

    public void populate(UIComponents uiComponents) {
        ArrayList<ITrack> tds = new ArrayList<ITrack>();
        for (ITrack td : this.m_recording.getRootGroup().getAllTracks()) {
            if (!"vm/gc/phases/pause".equals(td.getName())) continue;
            tds.add(td);
        }
        this.addThreads(uiComponents);
        UIGarbageCollector uiGarbageCollector = new UIGarbageCollector(this.m_recording, tds);
        this.addGC(uiGarbageCollector);
        uiComponents.setGarbageCollector(uiGarbageCollector);
    }

    private void addGC(UIGarbageCollector gc) {
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_OLD_COLLECTIONS_LABEL, Color.RED, "vm/gc/old_garbage_collection");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_YOUNG_COLLECTIONS_LABEL, Color.RED, "vm/gc/young_garbage_collection");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_PAUSES_LABEL, Color.RED, "vm/gc/phases/pause");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_SUB_LEVEL_1_LABEL, Color.RED, "vm/gc/phases/pause_level_1");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_SUB_LEVEL_2_LABEL, Color.RED, "vm/gc/phases/pause_level_2");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_SUB_LEVEL_3_LABEL, Color.RED, "vm/gc/phases/pause_level_3");
        this.addTrackIfItExists(gc, Messages.UI_COMPONENT_BUILDER_GC_SUB_LEVEL_4_LABEL, Color.RED, "vm/gc/phases/pause_level_4");
    }

    private void addTrackIfItExists(UIGarbageCollector gc, String name, Color color, String ... paths) {
        UITrack track = this.createTrack(name, color, paths);
        if (track != null) {
            gc.addTrack(track);
            gc.addPaths(paths);
        }
    }

    private UITrack createTrack(String name, Color color, String ... identifiers) {
        ArrayList<ITrack> tds = new ArrayList<ITrack>();
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(Arrays.asList(identifiers));
        for (ITrack td : this.m_recording.getRootGroup().getAllTracks()) {
            if (td.getName() == null || !ids.contains(td.getName())) continue;
            tds.add(td);
        }
        if (!tds.isEmpty()) {
            return new UITrack(this.m_recording, tds, name, color);
        }
        return null;
    }
}

