/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.ImageDescriptorImageProvider;
import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SelectionIteratorFactory;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.fields.ContentTypeField;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.histogram.FieldViewerFilter;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItemProvider;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItemSelectionAdapter;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldBackgroundPainter;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.fields.PieFieldViewer;
import com.jrockit.mc.ui.layout.SimpleLayout;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class HistogramComponent<M extends HistogramModel>
extends ColumnViewerComponent
implements INavigatorSelectionChangeListener,
ITypeVisibilityChange,
IEventConsumer,
ITypeVisibilitySupport {
    private static final int COMBO_VISIBILITY_COUNT = 15;
    private HistogramItemProvider m_contentProvider;
    private Field m_pieChartField;
    private Composite m_userSelectable;
    private ComboViewer m_eventTypeComboViewer;
    private ComboViewer m_groupByComboViewer;
    private EventTypeAcceptor m_acceptor;
    private IEventType m_currentType;

    @Override
    public final void initializeUI() {
        super.initializeUI();
        if (this.hasUserGroupBy()) {
            this.updateComboContents();
        }
    }

    @Override
    public final boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            this.m_contentProvider = new HistogramItemProvider();
            this.m_contentProvider.setUserSelectable(this.hasUserGroupBy());
            this.m_acceptor = new EventTypeAcceptor(serviceLocator, this.getTypeRepository());
            return true;
        }
        return false;
    }

    public final boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    protected Composite createViewerPart(Composite parent, Field[] fields) {
        FormToolkit toolkit = this.getFormToolkit();
        Composite container = toolkit.createComposite(parent, 0);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        if (this.hasUserGroupBy()) {
            this.m_userSelectable = this.createUserSelectable(toolkit, container);
            this.m_userSelectable.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.isOperativeSettable()) {
                Button button = this.createOperativeSetButton(container);
                button.setLayoutData((Object)new GridData(4, 4, false, false));
            }
        }
        int columns = Math.max(container.getChildren().length, 1);
        GridData gd = new GridData(4, 4, true, true);
        Composite tablePieChart = this.createTablePieChart(toolkit, container);
        gd.horizontalSpan = columns;
        tablePieChart.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        container.setLayout((Layout)gl);
        return container;
    }

    private Composite createTablePieChart(FormToolkit toolkit, Composite parent) {
        FieldTableViewer tableViewer;
        PieFieldViewer pieViewer;
        Composite viewerContainer = toolkit.createComposite(parent, 0);
        viewerContainer.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SimpleLayout layout = new SimpleLayout();
        layout.setMargin(0);
        viewerContainer.setLayout((Layout)layout);
        String piePosition = this.getRepository().getPieChartPosition();
        ILabelProvider lp = this.createLabelProvider(parent.getDisplay());
        if ("west".equals(piePosition) || "north".equals(piePosition)) {
            pieViewer = this.createPieViewer(viewerContainer, (IBaseLabelProvider)lp);
            tableViewer = this.createTable(viewerContainer, lp);
        } else {
            tableViewer = this.createTable(viewerContainer, lp);
            pieViewer = this.createPieViewer(viewerContainer, (IBaseLabelProvider)lp);
        }
        if (pieViewer != null) {
            tableViewer.hookPieFieldViewer(pieViewer);
            this.hookPieSelectionListener(tableViewer, pieViewer);
        }
        layout.setHorizontalOrientation("east".equals(piePosition) || "west".equals(piePosition));
        return viewerContainer;
    }

    private ILabelProvider createLabelProvider(Display display) {
        if (this.getRepository().getShowPieChart()) {
            return new HistogramLabelProvider(true);
        }
        if (this.getRepository().hasImage()) {
            return new ImageDescriptorImageProvider(display, this.getRepository().getImageDescriptor());
        }
        return new HistogramLabelProvider(false);
    }

    private void hookPainter(final List<ColumnDescriptor> columnDescriptors, Table table) {
        table.addListener(40, (Listener)new FieldBackgroundPainter(this.getFields(), 1.0, 2){

            protected void drawFieldBackground(Event event, Object element, Object columnElement, Field field) {
                ColumnDescriptor cd = (ColumnDescriptor)columnDescriptors.get(field.INDEX);
                if (cd.getUseBackdrop() && columnElement instanceof Double) {
                    this.drawColumnPercentage(event, (Double)columnElement, new MCColor(200, 100, 100));
                }
            }
        });
    }

    private FieldTableViewer createTable(Composite viewerContainer, ILabelProvider lp) {
        Composite container = this.getFormToolkit().createComposite(viewerContainer, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        if (this.isFilterable()) {
            this.createTopControl(container).setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Table table = this.getFormToolkit().createTable(container, 268501762);
        FieldTableViewer tableViewer = new FieldTableViewer(table, this.getFields());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BoldFieldLabelProvider(this.getFields(), lp));
        tableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        tableViewer.setInput(this.getModelBuilder());
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        SimpleLayoutData tableData = new SimpleLayoutData();
        tableData.setWeight(5.0f);
        tableData.setVisible(this.getRepository().getShowTable());
        container.setLayoutData((Object)tableData);
        this.setViewer((StructuredViewer)tableViewer);
        this.hookModelView((ContentViewer)tableViewer, this.getModelBuilder());
        this.hookTableSelectionListener((StructuredViewer)tableViewer);
        if (this.hasBackdropColumn()) {
            this.hookPainter(this.getRepository().getColumnDescriptors(), table);
        }
        this.setupViewer();
        return tableViewer;
    }

    private Composite createUserSelectable(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        toolkit.paintBordersFor(container);
        container.setLayout((Layout)new FillLayout());
        this.m_eventTypeComboViewer = this.createComboViewer(toolkit, toolkit.createComposite(container, 0), Messages.HISTOGRAM_COMPONENT_EVENT_TYPE_COMBO_LABEL);
        this.m_eventTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IEventType e = (IEventType)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (e != null) {
                    HistogramComponent.this.selectEventType(e);
                }
            }
        });
        this.m_eventTypeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return null;
                }
                IEventType type = (IEventType)element;
                String path = type.getPath();
                int separator = -1;
                StringBuilder buf = new StringBuilder();
                while ((separator = path.indexOf(47, separator + 1)) > 0) {
                    buf.append(EventAppearance.getHumanSegmentName((String)path.substring(0, separator)));
                    buf.append(" / ");
                }
                buf.append(type.getName());
                return buf.toString();
            }
        });
        this.m_groupByComboViewer = this.createComboViewer(toolkit, toolkit.createComposite(container, 0), this.getRepository().getGroupColumn().getName());
        this.m_groupByComboViewer.setFilters(new ViewerFilter[]{new FieldViewerFilter()});
        this.m_groupByComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IField e = (IField)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (e != null) {
                    HistogramComponent.this.selectGroupByField(e);
                }
            }
        });
        this.m_groupByComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((IField)element).getName();
            }
        });
        return container;
    }

    private ComboViewer createComboViewer(FormToolkit toolkit, Composite parent, String labelText) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText(labelText);
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        label.setLayoutData((Object)gd1);
        Combo combo = new Combo(parent, 65544);
        combo.setVisibleItemCount(15);
        toolkit.adapt((Composite)combo);
        GridData gd2 = new GridData(4, 4, true, false);
        combo.setLayoutData((Object)gd2);
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setComparator(new ViewerComparator());
        return comboViewer;
    }

    private void hookPieSelectionListener(final FieldTableViewer tableViewer, PieFieldViewer pieViewer) {
        pieViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tableViewer.setSelection(event.getSelection(), true);
            }
        });
    }

    @Override
    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                if (this.hasUserGroupBy()) {
                    return this.getFields()[index + 1];
                }
                return this.getFields()[index];
            }
            ++index;
        }
        return null;
    }

    @Override
    protected void pushSelection(IStructuredSelection selection) {
        if (selection.getFirstElement() != null) {
            HistogramModel model = (HistogramModel)this.getModelBuilder().getModel();
            Iterable<IEvent> events = model.createHistogramIteratorFactory(selection);
            if (this.getRepository().getRole().getListener() != null) {
                for (IEventConsumer ec : this.getComponents().getCompatiblesWithChildren(IEventConsumer.class)) {
                    ec.consumeEvents(events, this.getRepository().getRole());
                }
            }
            ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setEventFactory(events);
            ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setSelectedRange(this.getModelBuilder().getView().getRange());
        } else if (this.getRepository().getRole().getListener() != null) {
            for (IEventConsumer ec : this.getComponents().getCompatiblesWithChildren(IEventConsumer.class)) {
                ec.consumeEvents(new SelectionIteratorFactory(), this.getRepository().getRole());
            }
        }
    }

    private void hookTableSelectionListener(StructuredViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistogramComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    public final StructuredViewer createViewer(Composite parent) {
        throw new UnsupportedOperationException("createViewerPart is overridden so this should never be called");
    }

    protected ISelectionProvider getSelectionProvider() {
        return new HistogramItemSelectionAdapter(super.getSelectionProvider());
    }

    @Override
    public final Field[] createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        if (this.hasUserGroupBy()) {
            ColumnDescriptor cd = this.getRepository().getGroupColumn();
            ContentTypeField field = new ContentTypeField(0);
            EventFieldToolkit.setupField(cd, field);
            EventFieldToolkit.hookColumnField(field, cd);
            field.setVisible(true);
            fields.add(field);
            ++index;
        }
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            Field field = EventFieldToolkit.createField(column, String.valueOf(column.getAttributeIdentifier()) + index, index);
            if (column.isInitialSortColumn()) {
                this.m_pieChartField = field;
            }
            fields.add(field);
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private PieFieldViewer createPieViewer(Composite parent, IBaseLabelProvider labelProvider) {
        if (this.getRepository().getShowPieChart()) {
            PieFieldViewer pieViewer = new PieFieldViewer(parent, this.getFields());
            this.getFormToolkit().adapt((Composite)pieViewer.getControl());
            pieViewer.setContentProvider((IContentProvider)this.m_contentProvider);
            pieViewer.setInput(this.getModelBuilder());
            pieViewer.setDataField(this.m_pieChartField);
            pieViewer.setLabelProvider(labelProvider);
            SimpleLayoutData pieData = new SimpleLayoutData();
            pieData.setMaxHorizontalRatio(1.0f);
            pieData.setWeight(1.0f);
            pieViewer.getControl().setLayoutData((Object)pieData);
            pieViewer.getControl().addTraverseListener((TraverseListener)new SimpleTraverseListener());
            this.hookModelView((ContentViewer)pieViewer, this.getModelBuilder());
            return pieViewer;
        }
        return null;
    }

    protected final AbstractFieldTableContentProvider getContentProvider() {
        return this.m_contentProvider;
    }

    @Override
    protected final HistogramColumnDescriptorRepository getRepository() {
        return (HistogramColumnDescriptorRepository)this.getComponentSettings().getChildObject("columnDescriptorRepository", HistogramColumnDescriptorRepository.class);
    }

    @Override
    public void onTypeVisibilityChange() {
        if (this.hasUserConstrainedEventTypes()) {
            this.markDirty();
        }
    }

    @Override
    public void refresh() {
        if (this.hasUserConstrainedEventTypes()) {
            if (this.hasUserGroupBy()) {
                this.m_acceptor = new EventTypeAcceptor(this.getServiceLocator(), this.getTypeRepository());
                this.updateComboContents();
            } else {
                EventTypeAcceptor a = new EventTypeAcceptor(this.getServiceLocator(), this.getTypeRepository());
                this.getModelBuilder().getView().setEventTypes(a.getAcceptedSet());
            }
        }
        this.getModelBuilder().scheduleRebuild();
    }

    private boolean hasUserGroupBy() {
        return this.getRepository().getUserSelectableGroupBy();
    }

    private boolean hasUserConstrainedEventTypes() {
        return this.getRepository().getEventTypeDescriptorRepository().getUserFilterConstrained();
    }

    private void updateComboContents() {
        if (HistogramComponent.hasValidControl(this.m_eventTypeComboViewer)) {
            IEventType selected = this.getSelectedEventType();
            this.m_eventTypeComboViewer.setInput(this.m_acceptor.getAcceptedSet());
            if (selected != null) {
                this.m_eventTypeComboViewer.getControl().setEnabled(true);
                this.m_eventTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
            }
            if (this.getSelectedEventType() == null) {
                this.m_eventTypeComboViewer.getCombo().select(0);
                this.selectEventType(this.getSelectedEventType());
            }
            this.m_eventTypeComboViewer.getControl().setEnabled(!this.m_eventTypeComboViewer.getSelection().isEmpty());
        }
    }

    private IEventType getSelectedEventType() {
        if (HistogramComponent.hasValidControl(this.m_eventTypeComboViewer)) {
            return (IEventType)((IStructuredSelection)this.m_eventTypeComboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    private static boolean hasValidControl(ComboViewer cv) {
        return cv != null && cv.getControl() != null && !cv.getControl().isDisposed();
    }

    private EventTypeDescriptorRepository getTypeRepository() {
        return this.getRepository().getEventTypeDescriptorRepository();
    }

    private void selectGroupByField(IField field) {
        if (field == null) {
            ((ContentTypeField)this.getFields()[0]).setContentTypeString("");
            this.getRepository().setGroupByAttribute("");
        } else {
            ((ContentTypeField)this.getFields()[0]).setContentTypeString(field.getContentType());
            this.getRepository().setGroupByAttribute(field.getIdentifier());
        }
        this.getModelBuilder().scheduleRebuild();
    }

    private void selectEventType(IEventType type) {
        if (type != this.m_currentType) {
            if (type == null) {
                this.m_groupByComboViewer.setInput((Object)Collections.EMPTY_LIST);
                this.m_groupByComboViewer.getControl().setEnabled(false);
                this.getModelBuilder().getView().setEventTypes(Collections.emptyList());
            } else {
                this.m_groupByComboViewer.setInput((Object)type.getFields());
                IField firstField = (IField)this.m_groupByComboViewer.getElementAt(0);
                if (firstField != null) {
                    this.m_groupByComboViewer.setSelection((ISelection)new StructuredSelection((Object)firstField));
                    this.m_groupByComboViewer.getControl().setEnabled(true);
                }
                this.getModelBuilder().getView().setEventTypes(Arrays.asList(type));
            }
            this.getModelBuilder().scheduleRebuild();
            this.m_currentType = type;
        }
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getRepository().getEventTypeDescriptorRepository();
    }
}

