/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ByteParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ConstantMap;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ParserFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ShortParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.IPoolFactory;
import com.jrockit.mc.flightrecorder.internal.parser.model.ContentType;

class ConstantPool
implements IParser {
    private final ConstantMap map;
    private final ContentType contentType;
    private final IPoolUser user;
    private final ParserFactory parserFactory;
    private IParser valueParser;

    public ConstantPool(ParserFactory parserFactory, IPoolFactory objectFactory, IPoolUser user, ContentType contentType) {
        this.map = new ConstantMap(objectFactory);
        this.contentType = contentType;
        this.parserFactory = parserFactory;
        this.user = user;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void insertValue(byte[] data, Offset offset, long timestamp) throws InvalidFlrFileException {
        if (this.valueParser == null) {
            this.valueParser = this.parserFactory.createParser(this.contentType.getDataStructure());
        }
        long key = this.readKey(data, offset);
        this.map.put(key, this.valueParser.read(data, offset), timestamp);
    }

    public void setLoadDone() {
        this.map.setLoadDone();
    }

    public void touchAll() {
        this.map.touchAll();
    }

    @Override
    public Object read(byte[] data, Offset offset) throws InvalidFlrFileException {
        long key = this.readKey(data, offset);
        return this.map.get(key, this.user.getCurrentEventTimestamp());
    }

    public long readKey(byte[] data, Offset offset) throws InvalidFlrFileException {
        switch (this.contentType.getDataType()) {
            case BYTE: 
            case U1: {
                return ByteParser.readByte(data, offset);
            }
            case SHORT: 
            case U2: {
                return ShortParser.readShort(data, offset);
            }
            case INTEGER: 
            case U4: 
            case FLOAT: {
                return IntegerParser.readInt(data, offset);
            }
            case LONG: 
            case U8: 
            case DOUBLE: {
                return LongParser.readLong(data, offset);
            }
        }
        throw new IllegalStateException("Not a valid data type for the constant pool. Must be numeric");
    }

    static interface IPoolUser {
        public long getCurrentEventTimestamp();
    }
}

