/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary.factories;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.EqualityProxy;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.IPoolFactory;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptorToolkit;
import java.util.HashMap;

public final class StackTraceFactory
implements IPoolFactory {
    private final boolean m_showHiddenMethods;
    private final int m_frameIndex;
    private final int m_truncateIndex;
    private final int m_methodIndex;
    private final int m_lineNumberIndex;
    private final int m_frameTypeIndex;
    private final int m_bciIndex;
    private final int m_fieldCount;
    private final HashMap<EqualityProxy<FLRStackTrace>, EqualityProxy<FLRStackTrace>> m_map = new HashMap();

    public StackTraceFactory(ValueDescriptor[] traceDescriptors, boolean showHiddenMethods) {
        this.m_showHiddenMethods = showHiddenMethods;
        this.m_frameIndex = ValueDescriptorToolkit.getIndex(traceDescriptors, "frames");
        this.m_truncateIndex = ValueDescriptorToolkit.getIndex(traceDescriptors, "truncated");
        if (this.m_frameIndex != -1) {
            ValueDescriptor frameDescriptor = traceDescriptors[this.m_frameIndex];
            this.m_methodIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "method");
            this.m_lineNumberIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "line");
            this.m_frameTypeIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "type");
            this.m_bciIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "bci");
        } else {
            this.m_methodIndex = -1;
            this.m_lineNumberIndex = -1;
            this.m_frameTypeIndex = -1;
            this.m_bciIndex = -1;
        }
        this.m_fieldCount = traceDescriptors.length;
    }

    @Override
    public synchronized Object createObject(long identifier, Object o) {
        if (o != null) {
            FLRStackTrace t = this.createTrace(o);
            EqualityProxy<FLRStackTrace> newTrace = new EqualityProxy<FLRStackTrace>(t);
            EqualityProxy<FLRStackTrace> oldTrace = this.m_map.get(newTrace);
            if (oldTrace == null) {
                this.m_map.put(newTrace, newTrace);
                return t;
            }
            return oldTrace.getObject();
        }
        return null;
    }

    private FLRStackTrace createTrace(Object o) {
        Object[] frames;
        Boolean truncated = null;
        if (this.m_fieldCount > 1) {
            Object[] objArr = (Object[])o;
            frames = (Object[])objArr[this.m_frameIndex];
            if (this.m_truncateIndex != -1) {
                truncated = (Boolean)objArr[this.m_truncateIndex];
            }
        } else {
            frames = (Object[])o;
        }
        FLRFrame[] flrFrames = new FLRFrame[frames.length];
        int n = 0;
        while (n < frames.length) {
            flrFrames[n] = this.createFrame((Object[])frames[n]);
            ++n;
        }
        return new FLRStackTrace(flrFrames, truncated, this.m_showHiddenMethods);
    }

    private FLRFrame createFrame(Object[] frameObject) {
        IMCMethod method = this.m_methodIndex != -1 ? (IMCMethod)frameObject[this.m_methodIndex] : null;
        Integer line = this.m_lineNumberIndex != -1 ? (Integer)frameObject[this.m_lineNumberIndex] : null;
        IMCFrame.Type type = this.m_frameTypeIndex != -1 ? this.getType((String)frameObject[this.m_frameTypeIndex]) : null;
        Integer bci = this.m_bciIndex != -1 ? (Integer)frameObject[this.m_bciIndex] : null;
        return new FLRFrame(method, bci, line, type);
    }

    private IMCFrame.Type getType(String type) {
        if ("Interpreted".equals(type)) {
            return IMCFrame.Type.INTERPRETED;
        }
        if ("JIT compiled".equals(type)) {
            return IMCFrame.Type.JIT_COMPILED;
        }
        if ("Inlined".equals(type)) {
            return IMCFrame.Type.INLINED;
        }
        return IMCFrame.Type.UNKNOWN;
    }
}

