/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.util.EmptyIterator;
import java.util.Collection;
import java.util.Iterator;

final class TrackIterator
implements Iterator<IEvent> {
    private static final EmptyIterator<IEvent> EMPTY_ITERATOR = new EmptyIterator();
    private final ITimeRange m_range;
    private final IEventFilter m_filter;
    private final Expansion m_expansion;
    private Iterator<IEvent> m_eventIterator = new EmptyIterator<IEvent>();
    private final Iterator<EventStorage> m_trackIterator;
    private EventStorage m_currentTrack;

    public TrackIterator(Collection<EventStorage> tracks, ITimeRange range, IEventFilter filter, Expansion expansion) {
        for (EventStorage track : tracks) {
            track.iterator();
        }
        this.m_trackIterator = tracks.iterator();
        this.m_range = range;
        this.m_filter = filter;
        this.m_expansion = expansion;
        this.internalNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_eventIterator.hasNext();
    }

    @Override
    public IEvent next() {
        IEvent event = this.m_eventIterator.next();
        this.internalNext();
        return event;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by the iterator.");
    }

    private void internalNext() {
        if (!this.m_eventIterator.hasNext()) {
            while (this.m_trackIterator.hasNext()) {
                this.m_currentTrack = this.m_trackIterator.next();
                this.m_eventIterator = this.m_currentTrack.iterator(this.m_filter, this.m_range, this.m_expansion);
                if (!this.m_eventIterator.hasNext()) continue;
                return;
            }
            this.m_eventIterator = EMPTY_ITERATOR;
        }
    }
}

