/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openide.awt.Notification;
import org.openide.awt.NotificationCategoryFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class NotificationDisplayer {
    public static NotificationDisplayer getDefault() {
        NotificationDisplayer notificationDisplayer = (NotificationDisplayer)Lookup.getDefault().lookup(NotificationDisplayer.class);
        if (null == notificationDisplayer) {
            Logger.getLogger(NotificationDisplayer.class.getName()).log(Level.INFO, "No NotificationDisplayer implementation available.");
            notificationDisplayer = new SimpleNotificationDisplayer();
        }
        return notificationDisplayer;
    }

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener) {
        return this.notify(string, icon, string2, actionListener, Priority.NORMAL);
    }

    public abstract Notification notify(String var1, Icon var2, String var3, ActionListener var4, Priority var5);

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, Priority priority, Category category) {
        return this.notify(string, icon, string2, actionListener, priority);
    }

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, Priority priority, String string3) {
        return this.notify(string, icon, string2, actionListener, priority, NotificationCategoryFactory.getInstance().getCategory(string3));
    }

    public abstract Notification notify(String var1, Icon var2, JComponent var3, JComponent var4, Priority var5);

    public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, Priority priority, Category category) {
        return this.notify(string, icon, jComponent, jComponent2, priority);
    }

    public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, Priority priority, String string2) {
        return this.notify(string, icon, jComponent, jComponent2, priority, NotificationCategoryFactory.getInstance().getCategory(string2));
    }

    static Category createCategory(Map<String, String> map) {
        return NotificationCategoryFactory.create(map);
    }

    private static class NotificationImpl
    extends Notification {
        private final StatusDisplayer.Message msg;

        public NotificationImpl(StatusDisplayer.Message message) {
            this.msg = message;
        }

        @Override
        public void clear() {
            this.msg.clear(0);
        }
    }

    private static class SimpleNotificationDisplayer
    extends NotificationDisplayer {
        private SimpleNotificationDisplayer() {
        }

        @Override
        public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, Priority priority) {
            return this.notify(string + " - " + string2, priority);
        }

        @Override
        public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, Priority priority) {
            return this.notify(string, priority);
        }

        private Notification notify(String string, Priority priority) {
            int n = 1;
            switch (priority) {
                case HIGH: {
                    n = 100;
                    break;
                }
                case NORMAL: {
                    n = 50;
                    break;
                }
                case LOW: 
                case SILENT: {
                    n = 1;
                }
            }
            StatusDisplayer.Message message = StatusDisplayer.getDefault().setStatusText(string, n);
            return new NotificationImpl(message);
        }
    }

    public static final class Category
    implements Comparable<Category> {
        public static final Category INFO = new Category("default_category_info", NbBundle.getMessage(NotificationDisplayer.class, (String)"INFO_CATEGORY"), NbBundle.getMessage(NotificationDisplayer.class, (String)"INFO_CATEGORY_DESCRIPTION"));
        public static final Category WARNING = new Category("default_category_warning", NbBundle.getMessage(NotificationDisplayer.class, (String)"WARNING_CATEGORY"), NbBundle.getMessage(NotificationDisplayer.class, (String)"WARNING_CATEGORY_DESCRIPTION"));
        public static final Category ERROR = new Category("default_category_error", NbBundle.getMessage(NotificationDisplayer.class, (String)"ERROR_CATEGORY"), NbBundle.getMessage(NotificationDisplayer.class, (String)"ERROR_CATEGORY_DESCRIPTION"));
        private final String name;
        private final String displayName;
        private final String description;
        private int index;

        Category(String string, String string2, String string3) {
            this.name = string;
            this.displayName = string2;
            this.description = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        void setIndex(int n) {
            this.index = n;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(Category category) {
            return this.index - category.index;
        }

        public static List<Category> getCategories() {
            return NotificationCategoryFactory.getInstance().getCategories();
        }

        static List<Category> getDefaultCategories() {
            ArrayList<Category> arrayList = new ArrayList<Category>();
            arrayList.add(ERROR);
            arrayList.add(WARNING);
            arrayList.add(INFO);
            return arrayList;
        }
    }

    public static enum Priority {
        HIGH(new ImageIcon(ImageUtilities.loadImage((String)"org/openide/awt/resources/priority_high.png"))),
        NORMAL(new ImageIcon(ImageUtilities.loadImage((String)"org/openide/awt/resources/priority_normal.png"))),
        LOW(new ImageIcon(ImageUtilities.loadImage((String)"org/openide/awt/resources/priority_low.png"))),
        SILENT(new ImageIcon(ImageUtilities.loadImage((String)"org/openide/awt/resources/priority_silent.png")));

        private final Icon icon;

        private Priority(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

