/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public abstract class GraphPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String NO_DATA_TOOLTIP = messages.getString("GraphPanel_NoDataTooltip");
    private static final String MAX_VALUE_STRING = messages.getString("GraphPanel_MaxValueString");
    protected static final DateFormat DATE_FORMATTER;
    protected static final NumberFormat INT_FORMATTER;
    protected static final NumberFormat PERCENT_FORMATTER;
    protected static final double INITIAL_CHART_SCALEX = 0.02;
    protected static final long SMALL_CHART_FIT_TO_WINDOW_PERIOD = 180000L;
    private ProfilerXYTooltipModel tooltipModel;
    private SmallTooltip lastTooltip;
    private SmallTooltipManager smallTooltipManager;

    protected String getMaxValueString(String string) {
        return MessageFormat.format(MAX_VALUE_STRING, string);
    }

    protected ProfilerXYChart createChart(SynchronousXYItemsModel synchronousXYItemsModel, PaintersModel paintersModel, boolean bl) {
        ProfilerXYChart profilerXYChart;
        if (bl) {
            profilerXYChart = new ProfilerXYChart(synchronousXYItemsModel, paintersModel){

                public JToolTip createToolTip() {
                    GraphPanel.this.lastTooltip = new SmallTooltip(this);
                    return GraphPanel.this.lastTooltip;
                }

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return GraphPanel.getSmallTooltipLocation(mouseEvent, GraphPanel.this.smallTooltipManager);
                }
            };
            this.smallTooltipManager = new SmallTooltipManager(profilerXYChart);
            profilerXYChart.setToolTipText(NO_DATA_TOOLTIP);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)profilerXYChart));
        } else {
            profilerXYChart = new ProfilerXYChart(synchronousXYItemsModel, paintersModel);
        }
        profilerXYChart.getSelectionModel().setHoverMode(102);
        return profilerXYChart;
    }

    public abstract Action[] getActions();

    protected ProfilerXYTooltipModel getTooltipModel() {
        if (this.tooltipModel == null) {
            this.tooltipModel = this.createTooltipModel();
        }
        return this.tooltipModel;
    }

    protected abstract ProfilerXYTooltipModel createTooltipModel();

    private static Point getSmallTooltipLocation(MouseEvent mouseEvent, SmallTooltipManager smallTooltipManager) {
        Point point = mouseEvent.getPoint();
        smallTooltipManager.setMousePosition(point);
        point.y += 25;
        return point;
    }

    static {
        String string = MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR);
        DATE_FORMATTER = new SimpleDateFormat(string);
        INT_FORMATTER = NumberFormat.getIntegerInstance();
        INT_FORMATTER.setGroupingUsed(true);
        PERCENT_FORMATTER = NumberFormat.getPercentInstance();
        PERCENT_FORMATTER.setMinimumFractionDigits(1);
        PERCENT_FORMATTER.setMaximumIntegerDigits(2);
    }

    private class SmallTooltipManager
    implements ChartSelectionListener {
        private boolean timerRunning = false;
        private int mouseX;
        private int mouseY;
        private ProfilerXYChart chart;

        public SmallTooltipManager(ProfilerXYChart profilerXYChart) {
            this.chart = profilerXYChart;
            profilerXYChart.getSelectionModel().addSelectionListener((ChartSelectionListener)this);
        }

        public void setMousePosition(Point point) {
            this.mouseX = point.x;
            this.mouseY = point.y;
        }

        private void enableSelection() {
            this.chart.getSelectionModel().setHoverMode(102);
        }

        private void disableSelection() {
            if (this.timerRunning) {
                return;
            }
            this.timerRunning = true;
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SmallTooltipManager.this.isTooltipShowing()) {
                        SmallTooltipManager.this.chart.getSelectionModel().setHoverMode(100);
                        SmallTooltipManager.this.chart.setToolTipText(NO_DATA_TOOLTIP);
                    }
                    SmallTooltipManager.this.timerRunning = false;
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        private boolean isTooltipShowing() {
            return GraphPanel.this.lastTooltip != null && GraphPanel.this.lastTooltip.isShowing();
        }

        private void updateTooltipText(List<ItemSelection> list) {
            if (!this.isTooltipShowing()) {
                return;
            }
            if (list.isEmpty()) {
                this.chart.setToolTipText(NO_DATA_TOOLTIP);
            } else {
                this.chart.setToolTipText(this.getTooltipText(list));
            }
            MouseEvent mouseEvent = new MouseEvent((Component)((Object)this.chart), 0, 0L, 0, this.mouseX, this.mouseY, 0, false);
            ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
        }

        private String getTooltipText(List<ItemSelection> list) {
            int n;
            ProfilerXYTooltipModel profilerXYTooltipModel = GraphPanel.this.getTooltipModel();
            int n2 = profilerXYTooltipModel.getRowsCount();
            if (list.size() != n2) {
                return "Rows and selected items don't match";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            XYItemSelection xYItemSelection = (XYItemSelection)list.get(0);
            long l = xYItemSelection.getItem().getXValue(xYItemSelection.getValueIndex());
            stringBuilder.append("&nbsp;&nbsp;");
            stringBuilder.append(profilerXYTooltipModel.getTimeValue(l));
            stringBuilder.append("&nbsp;&nbsp;");
            stringBuilder.append("<hr>");
            for (n = 0; n < n2; ++n) {
                stringBuilder.append("<b>&nbsp;&nbsp;");
                stringBuilder.append(profilerXYTooltipModel.getRowName(n));
                stringBuilder.append(":</b>&nbsp;&nbsp;");
                XYItemSelection xYItemSelection2 = (XYItemSelection)list.get(n);
                long l2 = xYItemSelection2.getItem().getYValue(xYItemSelection2.getValueIndex());
                stringBuilder.append(profilerXYTooltipModel.getRowValue(n, l2));
                stringBuilder.append("&nbsp;");
                stringBuilder.append(profilerXYTooltipModel.getRowUnits(n, l2));
                stringBuilder.append("&nbsp;&nbsp;<br>");
            }
            n = profilerXYTooltipModel.getExtraRowsCount();
            if (n > 0) {
                stringBuilder.append("<hr>");
            }
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("<b>&nbsp;&nbsp;");
                stringBuilder.append(profilerXYTooltipModel.getExtraRowName(i));
                stringBuilder.append(":</b>&nbsp;&nbsp;");
                stringBuilder.append(profilerXYTooltipModel.getExtraRowValue(i));
                stringBuilder.append("&nbsp;");
                stringBuilder.append(profilerXYTooltipModel.getExtraRowUnits(i));
                stringBuilder.append("&nbsp;&nbsp;<br>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        public void selectionModeChanged(int n, int n2) {
        }

        public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        }

        public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            this.updateTooltipText(list);
        }

        public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        }
    }

    private class SmallTooltip
    extends JToolTip {
        public SmallTooltip(ProfilerXYChart profilerXYChart) {
            this.setComponent((JComponent)((Object)profilerXYChart));
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                        if (SmallTooltip.this.isShowing()) {
                            GraphPanel.this.smallTooltipManager.enableSelection();
                        } else {
                            GraphPanel.this.smallTooltipManager.disableSelection();
                        }
                    }
                }
            });
        }
    }
}

