/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.concurrent.unitofwork;

import at.itsv.commons.concurrent.unitofwork.ThreadLocalUnitOfWork;
import at.itsv.commons.concurrent.unitofwork.UnitOfWork;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

final class DefaultUnitOfWork
implements UnitOfWork {
    private final Queue<UnitOfWork.CommitListener> commitListeners = new ConcurrentLinkedQueue<UnitOfWork.CommitListener>();
    private final Queue<UnitOfWork.RollbackListener> rollbackListeners = new ConcurrentLinkedQueue<UnitOfWork.RollbackListener>();
    private final Queue<UnitOfWork.CleanupListener> cleanupListeners = new ConcurrentLinkedQueue<UnitOfWork.CleanupListener>();
    private boolean started;

    DefaultUnitOfWork() {
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("Unit of work bereits gestartet");
        }
        this.started = true;
    }

    @Override
    public void commit() {
        this.ensureStarted();
        try {
            for (UnitOfWork.CommitListener listener : this.commitListeners) {
                listener.onCommit(this);
            }
            this.stopAndClearCurrent();
            this.notifyListenersOfCleanup();
        }
        catch (RuntimeException ex) {
            this.rollback(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Throwable cause) {
        this.ensureStarted();
        try {
            for (UnitOfWork.RollbackListener listener : this.rollbackListeners) {
                listener.onRollback(this, cause);
            }
        }
        finally {
            this.stopAndClearCurrent();
            this.notifyListenersOfCleanup();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private void ensureStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Unit of Work nicht gestartet");
        }
    }

    private void stopAndClearCurrent() {
        this.started = false;
        ThreadLocalUnitOfWork.clear(this);
    }

    private void notifyListenersOfCleanup() {
        for (UnitOfWork.CleanupListener listener : this.cleanupListeners) {
            listener.onCleanup(this);
        }
    }

    @Override
    public void registerCommitListener(UnitOfWork.CommitListener listener) {
        Objects.requireNonNull(listener);
        if (!this.commitListeners.contains(listener)) {
            this.commitListeners.add(listener);
        }
    }

    @Override
    public void registerRollbackListener(UnitOfWork.RollbackListener listener) {
        Objects.requireNonNull(listener);
        if (!this.rollbackListeners.contains(listener)) {
            this.rollbackListeners.add(listener);
        }
    }

    @Override
    public void registerCleanupListener(UnitOfWork.CleanupListener listener) {
        Objects.requireNonNull(listener);
        if (!this.cleanupListeners.contains(listener)) {
            this.cleanupListeners.add(listener);
        }
    }
}

