/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.concurrent.unitofwork;

import at.itsv.commons.concurrent.unitofwork.DefaultUnitOfWork;
import at.itsv.commons.concurrent.unitofwork.UnitOfWork;
import java.util.Objects;

public final class ThreadLocalUnitOfWork {
    private static final ThreadLocal<UnitOfWork> CURRENT = new ThreadLocal();

    private ThreadLocalUnitOfWork() {
    }

    public static boolean isStarted() {
        UnitOfWork current = CURRENT.get();
        return current != null && current.isStarted();
    }

    public static void startIfNoneStarted() {
        UnitOfWork current = CURRENT.get();
        if (current != null) {
            if (!current.isStarted()) {
                current.start();
            }
        } else {
            DefaultUnitOfWork newUoW = new DefaultUnitOfWork();
            ThreadLocalUnitOfWork.set(newUoW);
            newUoW.start();
        }
    }

    public static UnitOfWork get() {
        UnitOfWork uow = CURRENT.get();
        if (uow == null) {
            throw new IllegalStateException("Es existiert keine Unit of Work fuer diesen Thread");
        }
        return uow;
    }

    public static void set(UnitOfWork uow) {
        Objects.requireNonNull(uow, "uow");
        UnitOfWork current = CURRENT.get();
        if (current != null && current.isStarted()) {
            throw new IllegalStateException("Es ist bereits eine Unit of Work gesetzt, die bereits gestartet wurde");
        }
        CURRENT.set(uow);
    }

    public static void clear(UnitOfWork uow) {
        UnitOfWork current = CURRENT.get();
        if (current != null && current.equals(uow)) {
            ThreadLocalUnitOfWork.clear();
        }
    }

    static void clear() {
        CURRENT.remove();
    }
}

