/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.events;

import at.itsv.commons.events.EventBus;
import at.itsv.commons.events.EventListener;
import at.itsv.commons.events.TypedEventListener;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SynchronousEventBus
implements EventBus {
    private final Set<TypedEventListener<?>> listeners = new CopyOnWriteArraySet();

    @Override
    public <T> EventBus.Subscription subscribe(Class<T> eventType, EventListener<? super T> listener) {
        TypedEventListener eventListener = new TypedEventListener(eventType, listener);
        this.listeners.add(eventListener);
        return () -> this.listeners.remove(eventListener);
    }

    @Override
    public void publishEvent(Object event) {
        Objects.requireNonNull(event, "event");
        for (TypedEventListener<?> listener : this.listeners) {
            listener.onEvent(event);
        }
    }
}

