/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.concurrent.state;

import at.itsv.commons.concurrent.state.State;
import java.util.Objects;

final class ThreadLocalState<T>
implements State<T> {
    private final ThreadLocal<T> threadLocal;

    ThreadLocalState(ThreadLocal<T> threadLocal) {
        this.threadLocal = threadLocal;
    }

    ThreadLocalState() {
        this(new ThreadLocal());
    }

    @Override
    public void accept(T value) {
        Objects.requireNonNull(value, "value");
        this.threadLocal.set(value);
    }

    @Override
    public T get() {
        T value = this.threadLocal.get();
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

