/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.config.keyvalue;

import at.itsv.commons.config.keyvalue.EmptyConfiguration;
import at.itsv.commons.config.keyvalue.JndiConfiguration;
import at.itsv.commons.config.keyvalue.MapConfiguration;
import at.itsv.commons.config.keyvalue.PrefixedConfiguration;
import at.itsv.commons.config.keyvalue.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.naming.Context;

public interface KeyValueConfiguration {
    public Optional<String> valueOf(String var1);

    default public String requiredValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.valueOf(name).orElseThrow(() -> new NoSuchElementException(Utils.requiredValueNotDefinedMessage(name)));
    }

    public Optional<Integer> intValueOf(String var1);

    default public int requiredIntValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.intValueOf(name).orElseThrow(() -> new NoSuchElementException(Utils.requiredValueNotDefinedMessage(name)));
    }

    public Optional<Long> longValueOf(String var1);

    default public long requiredLongValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.longValueOf(name).orElseThrow(() -> new NoSuchElementException(Utils.requiredValueNotDefinedMessage(name)));
    }

    public Optional<Boolean> booleanValueOf(String var1);

    default public boolean requiredBooleanValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.booleanValueOf(name).orElseThrow(() -> new NoSuchElementException(Utils.requiredValueNotDefinedMessage(name)));
    }

    public Optional<Double> doubleValueOf(String var1);

    default public long requiredDoubleValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.longValueOf(name).orElseThrow(() -> new NoSuchElementException(Utils.requiredValueNotDefinedMessage(name)));
    }

    default public KeyValueConfiguration withPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        return PrefixedConfiguration.of(this, prefix);
    }

    public int hashCode();

    public boolean equals(Object var1);

    public static KeyValueConfiguration backedBy(Properties properties) {
        Properties m = properties;
        return KeyValueConfiguration.backedBy((Map<String, String>)m);
    }

    public static KeyValueConfiguration backedBy(Context context) {
        Objects.requireNonNull(context, "context");
        return new JndiConfiguration(context);
    }

    public static KeyValueConfiguration backedByInitialContext() {
        return KeyValueConfiguration.backedBy(Utils.initialContextSingleton());
    }

    public static KeyValueConfiguration backedBy(Map<String, String> map) {
        Objects.requireNonNull(map, "map");
        return new MapConfiguration(map);
    }

    public static KeyValueConfiguration backedByCopyOf(Map<String, String> map) {
        Objects.requireNonNull(map, "map");
        return KeyValueConfiguration.backedBy(new HashMap<String, String>(map));
    }

    public static KeyValueConfiguration empty() {
        return new EmptyConfiguration();
    }

    public static interface StringBased
    extends KeyValueConfiguration {
        @Override
        default public Optional<Integer> intValueOf(String name) {
            Objects.requireNonNull(name, "name");
            return this.valueOf(name).map(Integer::parseInt);
        }

        @Override
        default public Optional<Long> longValueOf(String name) {
            Objects.requireNonNull(name, "name");
            return this.valueOf(name).map(Long::parseLong);
        }

        @Override
        default public Optional<Boolean> booleanValueOf(String name) {
            Objects.requireNonNull(name, "name");
            return this.valueOf(name).map(Boolean::parseBoolean);
        }

        @Override
        default public Optional<Double> doubleValueOf(String name) {
            Objects.requireNonNull(name, "name");
            return this.valueOf(name).map(Double::parseDouble);
        }
    }
}

