/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.config.keyvalue;

import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import java.util.Objects;
import java.util.Optional;

final class PrefixedConfiguration
implements KeyValueConfiguration {
    private final KeyValueConfiguration delegate;
    private final String prefix;

    private PrefixedConfiguration(KeyValueConfiguration delegate, String prefix) {
        this.prefix = prefix;
        this.delegate = delegate;
    }

    public static KeyValueConfiguration of(KeyValueConfiguration delegate, String prefix) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(prefix, "prefix");
        return prefix.isEmpty() ? delegate : new PrefixedConfiguration(delegate, prefix);
    }

    @Override
    public Optional<String> valueOf(String name) {
        return this.delegate.valueOf(this.prefix + name);
    }

    @Override
    public Optional<Boolean> booleanValueOf(String name) {
        return this.delegate.booleanValueOf(this.prefix + name);
    }

    @Override
    public Optional<Double> doubleValueOf(String name) {
        return this.delegate.doubleValueOf(this.prefix + name);
    }

    @Override
    public Optional<Integer> intValueOf(String name) {
        return this.delegate.intValueOf(this.prefix + name);
    }

    @Override
    public Optional<Long> longValueOf(String name) {
        return this.delegate.longValueOf(this.prefix + name);
    }

    @Override
    public KeyValueConfiguration withPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        return prefix.isEmpty() ? this : this.delegate.withPrefix(this.prefix + prefix);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.prefix);
        hash = 29 * hash + Objects.hashCode(this.delegate);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixedConfiguration other = (PrefixedConfiguration)obj;
        if (!Objects.equals(this.prefix, other.prefix)) {
            return false;
        }
        return Objects.equals(this.delegate, other.delegate);
    }

    public String toString() {
        return String.format("%s{prefix=[%s], delegate=[%s]}", PrefixedConfiguration.class.getSimpleName(), this.prefix, this.delegate);
    }
}

