/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringdecoding.collections;

import at.itsv.commons.stringdecoding.collections.StringToCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;

class StringToCollectionWithTrimming<T extends Collection<String>>
implements StringToCollection<T> {
    protected final Collector<String, ?, T> collector;
    protected final Pattern splitPattern;

    StringToCollectionWithTrimming(Collector<String, ?, T> collector, Pattern splitPattern) {
        this.collector = collector;
        this.splitPattern = splitPattern;
    }

    protected Stream<String> decoratedStream(Stream<String> tokenStream) {
        return tokenStream.map(String::trim).filter(token -> !token.isEmpty());
    }

    @Override
    public T decode(String encoded) {
        String[] tokens = this.splitPattern.split(encoded);
        return (T)((Collection)this.decoratedStream(Arrays.stream(tokens)).collect(this.collector));
    }

    @Override
    public StringToCollection<T> withoutTrimming() {
        return new WithoutTrimming(this.collector, this.splitPattern);
    }

    @Override
    public StringToCollection<T> withTrimming() {
        return this;
    }

    @Override
    public StringToCollection<T> withSplitPattern(Pattern pattern) {
        Objects.requireNonNull(pattern, "pattern");
        return new StringToCollectionWithTrimming<T>(this.collector, pattern);
    }

    private static final class WithoutTrimming<U extends Collection<String>>
    extends StringToCollectionWithTrimming<U> {
        private WithoutTrimming(Collector<String, ?, U> collector, Pattern splitPattern) {
            super(collector, splitPattern);
        }

        @Override
        public StringToCollection<U> withTrimming() {
            return new StringToCollectionWithTrimming(this.collector, this.splitPattern);
        }

        @Override
        public StringToCollection<U> withoutTrimming() {
            return this;
        }

        @Override
        public StringToCollection<U> withSplitPattern(Pattern pattern) {
            Objects.requireNonNull(pattern, "pattern");
            return new WithoutTrimming<U>(this.collector, pattern);
        }

        @Override
        protected Stream<String> decoratedStream(Stream<String> tokenStream) {
            return tokenStream;
        }
    }
}

