/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang;

import at.itsv.commons.lang.Result;

public final class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static <F> Result<F> createAssignableInstanceFromClassName(String className, Class<F> requiredType) {
        try {
            Class<?> actualType = Class.forName(className);
            if (requiredType.isAssignableFrom(actualType)) {
                return Result.success(requiredType.cast(actualType.newInstance()));
            }
            return Result.failure(new ClassCastException(String.format("Typ [%s] ist nicht kompatibel mit gefordertem Typ [%s]", actualType, requiredType)));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            return Result.failure(ex);
        }
    }
}

