/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class Lazy<T>
implements Supplier<T> {
    protected final Supplier<T> supplier;

    public static final <T> LoadedFromContinuation<T> loadFrom(Supplier<T> supplier) {
        return new LoadedFromContinuation(Objects.requireNonNull(supplier, "supplier"));
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public abstract T value();

    @Override
    public T get() {
        return this.value();
    }

    private static abstract class Result<T> {
        private Result() {
        }

        public abstract T get();

        public static <T> Result<T> of(Supplier<T> supplier) {
            try {
                T result = supplier.get();
                if (result == null) {
                    return new Failure(new NullPointerException("supplier hat null geliefert"));
                }
                return new Success<T>(result);
            }
            catch (RuntimeException ex) {
                return new Failure(ex);
            }
        }

        private static final class Failure<T>
        extends Result<T> {
            private final RuntimeException exception;

            Failure(RuntimeException exception) {
                this.exception = exception;
            }

            @Override
            public T get() {
                throw this.exception;
            }
        }

        private static final class Success<T>
        extends Result<T> {
            private final T value;

            Success(T value) {
                this.value = value;
            }

            @Override
            public T get() {
                return this.value;
            }
        }
    }

    private static final class NonLockingLazy<T>
    extends Lazy<T> {
        private Result<T> value = null;

        private NonLockingLazy(Supplier<T> supplier) {
            super(supplier);
        }

        @Override
        public T value() {
            if (this.value == null) {
                this.value = Result.of(this.supplier);
            }
            return this.value.get();
        }
    }

    private static final class AtomicLazy<T>
    extends Lazy<T> {
        private final AtomicReference<Result<T>> atomicReference = new AtomicReference<Object>(null);

        private AtomicLazy(Supplier<T> supplier) {
            super(supplier);
        }

        @Override
        public T value() {
            Result<T> value = this.atomicReference.get();
            if (value == null) {
                value = Result.of(this.supplier);
                this.atomicReference.compareAndSet(null, value);
            }
            return this.atomicReference.get().get();
        }
    }

    private static final class LockingLazy<T>
    extends Lazy<T> {
        private volatile Result<T> value = null;

        private LockingLazy(Supplier<T> supplier) {
            super(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T value() {
            Result<T> nonVolatileValue = this.value;
            if (nonVolatileValue == null) {
                LockingLazy lockingLazy = this;
                synchronized (lockingLazy) {
                    nonVolatileValue = this.value;
                    if (nonVolatileValue == null) {
                        nonVolatileValue = Result.of(this.supplier);
                        this.value = nonVolatileValue;
                    }
                }
            }
            return nonVolatileValue.get();
        }
    }

    public static final class LoadedFromContinuation<T> {
        private final Supplier<T> supplier;

        private LoadedFromContinuation(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public Lazy<T> andComputeAtMostOnce() {
            return new LockingLazy(this.supplier);
        }

        public Lazy<T> andAlwaysReturnTheSame() {
            return new AtomicLazy(this.supplier);
        }

        public Lazy<T> andDoNotCareAboutThreadSafety() {
            return new NonLockingLazy(this.supplier);
        }
    }
}

