/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.ThrewCheckedException;
import at.itsv.commons.lang.function.throwing.ThrewUnmappableCheckedException;
import java.util.Objects;
import java.util.function.Function;

public interface Throwing<E extends Exception, T> {
    default public T toUnchecked() {
        return this.toUnchecked(ThrewCheckedException::new);
    }

    public T toUnchecked(Function<? super Exception, ? extends RuntimeException> var1);

    public static <E extends Exception> Function<? super Exception, ? extends RuntimeException> typeCheckingExceptionMapper(Class<E> exceptionType, Function<? super E, ? extends RuntimeException> typedMapper) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(typedMapper, "typedMapper");
        return ex -> {
            try {
                return (RuntimeException)typedMapper.apply((Object)exceptionType.cast(ex));
            }
            catch (ClassCastException classCastEx) {
                throw new ThrewUnmappableCheckedException((Exception)ex, classCastEx);
            }
        };
    }
}

