/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.Throwing;
import at.itsv.commons.lang.function.throwing.Utils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingConsumer<T, E extends Exception>
extends Throwing<E, Consumer<T>> {
    public void accept(T var1) throws E;

    default public ThrowingConsumer<? super T, E> andThen(ThrowingConsumer<? super T, ? extends E> other) {
        Objects.requireNonNull(other, "other");
        return t -> {
            this.accept(t);
            other.accept(t);
        };
    }

    @Override
    default public Consumer<T> toUnchecked(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception ex) {
                throw Utils.toUnchecked(ex, exceptionMapper);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> uncheckedOf(ThrowingConsumer<T, E> throwing) {
        Objects.requireNonNull(throwing, "throwing");
        return (Consumer)throwing.toUnchecked();
    }

    public static <T, E extends Exception> Consumer<T> uncheckedOf(ThrowingConsumer<T, E> throwing, Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(throwing, "throwing");
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return throwing.toUnchecked(exceptionMapper);
    }

    public static <T> ThrowingConsumer<T, ? extends RuntimeException> of(Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return consumer::accept;
    }
}

