/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.Throwing;
import at.itsv.commons.lang.function.throwing.Utils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Exception>
extends Throwing<E, Predicate<T>> {
    public boolean test(T var1) throws E;

    default public ThrowingPredicate<T, E> and(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other, "other");
        return t -> this.test(t) && other.test(t);
    }

    default public ThrowingPredicate<T, E> or(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other, "other");
        return t -> this.test(t) || other.test(t);
    }

    default public ThrowingPredicate<T, E> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public Predicate<T> toUnchecked(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return t -> {
            try {
                return this.test(t);
            }
            catch (Exception ex) {
                throw Utils.toUnchecked(ex, exceptionMapper);
            }
        };
    }

    public static <T, E extends Exception> Predicate<T> uncheckedOf(ThrowingPredicate<T, E> throwing) {
        Objects.requireNonNull(throwing, "throwing");
        return (Predicate)throwing.toUnchecked();
    }

    public static <T, E extends Exception> Predicate<T> uncheckedOf(ThrowingPredicate<T, E> throwing, Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(throwing, "throwing");
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return throwing.toUnchecked(exceptionMapper);
    }

    public static <T> ThrowingPredicate<T, ? extends RuntimeException> of(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        return predicate::test;
    }
}

