/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class Arguments {
    private Arguments() {
    }

    public static <T> T require(T value, Predicate<? super T> predicate, String message) {
        return Arguments.require(value, predicate.test(value), message);
    }

    public static <T> T require(T value, boolean valid, String message) {
        if (!valid) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static void require(boolean valid, String message) {
        if (!valid) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        public static boolean notEmpty(String value) {
            return !value.isEmpty();
        }

        public static boolean notEmpty(Collection<?> value) {
            return !value.isEmpty();
        }

        public static boolean notEmpty(Map<?, ?> value) {
            return !value.isEmpty();
        }

        public static boolean notEmpty(Object[] value) {
            return value.length > 0;
        }

        public static <T extends Comparable<T>> Predicate<T> greaterThan(T other) {
            Objects.requireNonNull(other, "other");
            return v -> v.compareTo(other) > 0;
        }

        public static <T extends Comparable<T>> Predicate<T> greaterThanOrEqual(T other) {
            Objects.requireNonNull(other, "other");
            return v -> v.compareTo(other) >= 0;
        }
    }
}

