/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang;

import at.itsv.commons.lang.function.throwing.ThrowingConsumer;
import at.itsv.commons.lang.function.throwing.ThrowingFunction;
import at.itsv.commons.lang.function.throwing.ThrowingPredicate;
import at.itsv.commons.lang.function.throwing.ThrowingSupplier;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class Result<T> {
    public static final <T> Result<T> success(T value) {
        Objects.requireNonNull(value, "value");
        return new Success<T>(value);
    }

    public static final <T> Result<T> failure(Exception exception) {
        Objects.requireNonNull(exception, "exception");
        return new Failure(exception);
    }

    public static final <T> Result<T> of(ThrowingSupplier<T, ? extends Exception> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        try {
            T result = supplier.get();
            Objects.requireNonNull(result, "supplier.get()");
            return new Success<T>(result);
        }
        catch (Exception ex) {
            return new Failure(ex);
        }
    }

    public static final <T> Result<T> of(Optional<T> optional, Supplier<? extends Exception> exceptionSupplier) {
        Objects.requireNonNull(optional, "optional");
        Objects.requireNonNull(exceptionSupplier, "exceptionSupplier");
        if (optional.isPresent()) {
            return new Success<T>(optional.get());
        }
        return new Failure(exceptionSupplier.get());
    }

    private Result() {
    }

    public abstract boolean isSuccess();

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract T get() throws Exception;

    public abstract Exception getFailure();

    public abstract <X extends Exception> T orElseThrow(Function<? super Exception, X> var1) throws X;

    public abstract <U> U fold(Function<? super T, ? extends U> var1, Function<? super Exception, ? extends U> var2);

    public abstract <E extends Exception> void onSuccess(ThrowingConsumer<? super T, E> var1) throws E;

    public abstract <E extends Exception> void onFailure(ThrowingConsumer<Exception, E> var1) throws E;

    public abstract Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> var1);

    public abstract Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> var1, Function<? super T, ? extends Exception> var2);

    public abstract <U> Result<U> map(ThrowingFunction<? super T, ? extends U, ? extends Exception> var1);

    public abstract <U> Result<U> flatMap(ThrowingFunction<? super T, Result<U>, ? extends Exception> var1);

    public abstract Result<T> recover(ThrowingFunction<? super Exception, ? extends T, ? extends Exception> var1);

    public abstract Result<T> recoverWith(ThrowingFunction<? super Exception, Result<T>, ? extends Exception> var1);

    public abstract Optional<T> toOptional();

    public abstract Stream<T> toStream();

    private static final class Failure<T>
    extends Result<T> {
        private final Exception exception;

        Failure(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T get() throws Exception {
            throw this.exception;
        }

        @Override
        public Exception getFailure() {
            return this.exception;
        }

        @Override
        public <X extends Exception> T orElseThrow(Function<? super Exception, X> exceptionMapper) throws X {
            throw (Exception)exceptionMapper.apply(this.exception);
        }

        @Override
        public <U> U fold(Function<? super T, ? extends U> valueMapper, Function<? super Exception, ? extends U> exceptionMapper) {
            return exceptionMapper.apply(this.exception);
        }

        @Override
        public <U> Result<U> map(ThrowingFunction<? super T, ? extends U, ? extends Exception> mapper) {
            return this;
        }

        @Override
        public <U> Result<U> flatMap(ThrowingFunction<? super T, Result<U>, ? extends Exception> mapper) {
            return this;
        }

        @Override
        public Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> predicate) {
            return this;
        }

        @Override
        public Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> predicate, Function<? super T, ? extends Exception> failureExceptionSupplier) {
            return this;
        }

        @Override
        public Result<T> recover(ThrowingFunction<? super Exception, ? extends T, ? extends Exception> recovery) {
            try {
                return new Success<T>(recovery.apply(this.exception));
            }
            catch (Exception t) {
                return new Failure<T>(t);
            }
        }

        @Override
        public Result<T> recoverWith(ThrowingFunction<? super Exception, Result<T>, ? extends Exception> recovery) {
            try {
                return recovery.apply(this.exception);
            }
            catch (Exception t) {
                return new Failure<T>(t);
            }
        }

        @Override
        public <E extends Exception> void onSuccess(ThrowingConsumer<? super T, E> consumer) throws E {
        }

        @Override
        public <E extends Exception> void onFailure(ThrowingConsumer<Exception, E> consumer) throws E {
            consumer.accept(this.exception);
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.empty();
        }

        @Override
        public Stream<T> toStream() {
            return Stream.empty();
        }
    }

    private static final class Success<T>
    extends Result<T> {
        private final T value;

        Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Exception getFailure() {
            throw new NoSuchElementException("Not a failure");
        }

        @Override
        public <X extends Exception> T orElseThrow(Function<? super Exception, X> exceptionMapper) throws X {
            return this.value;
        }

        @Override
        public <U> U fold(Function<? super T, ? extends U> valueMapper, Function<? super Exception, ? extends U> exceptionMapper) {
            return valueMapper.apply(this.value);
        }

        @Override
        public <U> Result<U> map(ThrowingFunction<? super T, ? extends U, ? extends Exception> mapper) {
            try {
                return new Success<U>(mapper.apply(this.value));
            }
            catch (Exception t) {
                return new Failure(t);
            }
        }

        @Override
        public <U> Result<U> flatMap(ThrowingFunction<? super T, Result<U>, ? extends Exception> mapper) {
            try {
                return mapper.apply(this.value);
            }
            catch (Exception t) {
                return new Failure(t);
            }
        }

        @Override
        public Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> predicate, Function<? super T, ? extends Exception> failureExceptionSupplier) {
            try {
                return predicate.test(this.value) ? this : Result.failure(failureExceptionSupplier.apply(this.value));
            }
            catch (Exception t) {
                return Result.failure(t);
            }
        }

        @Override
        public Result<T> filter(ThrowingPredicate<? super T, ? extends Exception> predicate) {
            return this.filter(predicate, v -> new NoSuchElementException(String.format("Resultat [%s] passt nicht auf Filter [%s]", v, predicate.toString())));
        }

        @Override
        public Result<T> recover(ThrowingFunction<? super Exception, ? extends T, ? extends Exception> recovery) {
            return this;
        }

        @Override
        public Result<T> recoverWith(ThrowingFunction<? super Exception, Result<T>, ? extends Exception> recovery) {
            return this;
        }

        @Override
        public <E extends Exception> void onSuccess(ThrowingConsumer<? super T, E> consumer) throws E {
            consumer.accept(this.value);
        }

        @Override
        public <E extends Exception> void onFailure(ThrowingConsumer<Exception, E> consumer) throws E {
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.of(this.value);
        }

        @Override
        public Stream<T> toStream() {
            return Stream.of(this.value);
        }
    }
}

