/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Memoized<T, K, R>
implements Function<T, R> {
    private final Map<K, R> cache = new ConcurrentHashMap<K, R>(64);
    private final Function<T, K> keyTransformer;
    private final Function<T, R> delegate;

    private Memoized(Function<T, R> delegate, Function<T, K> keyTransformer) {
        this.delegate = delegate;
        this.keyTransformer = keyTransformer;
    }

    public static <T, R> Function<T, R> of(Function<T, R> function) {
        Objects.requireNonNull(function, "function");
        if (function instanceof Memoized) {
            return function;
        }
        return new Memoized<Object, Object, R>(function, key -> key);
    }

    public static <T, K, R> Function<T, R> of(Function<T, R> function, Function<T, K> keyTransformer) {
        Objects.requireNonNull(function, "function");
        Objects.requireNonNull(keyTransformer, "keyTransformer");
        if (function instanceof Memoized) {
            Memoized alreadyMemoized = (Memoized)function;
            if (alreadyMemoized.keyTransformer.equals(keyTransformer)) {
                return function;
            }
        }
        return new Memoized<T, K, R>(function, keyTransformer);
    }

    @Override
    public R apply(T t) {
        Objects.requireNonNull(t, "t");
        return (R)this.cache.computeIfAbsent(this.keyTransformer.apply(t), k -> this.nonNullResult(t));
    }

    private R nonNullResult(T t) {
        return Objects.requireNonNull(this.delegate.apply(t), () -> "Function returned null on input " + t);
    }
}

