/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function;

import at.itsv.commons.lang.function.Mapping;
import at.itsv.commons.lang.function.MappingImpl;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

final class SingleMapping<K, V>
implements Mapping<K, V> {
    private final K singleKey;
    private final V singleValue;

    SingleMapping(K key, V value) {
        this.singleKey = key;
        this.singleValue = value;
    }

    @Override
    public Optional<V> apply(K key) {
        Objects.requireNonNull(key, "key");
        return this.singleKey.equals(key) ? Optional.of(this.singleValue) : Optional.empty();
    }

    @Override
    public Mapping<K, V> and(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return new MappingImpl<K, V>(Collections.singletonMap(this.singleKey, this.singleValue), key, value);
    }
}

