/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.Throwing;
import at.itsv.commons.lang.function.throwing.Utils;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception>
extends Throwing<E, Function<T, R>> {
    public R apply(T var1) throws E;

    default public <V> ThrowingFunction<V, R, E> compose(ThrowingFunction<? super V, ? extends T, ? extends E> before) {
        Objects.requireNonNull(before, "before");
        return value -> this.apply(before.apply((Object)value));
    }

    default public <V> ThrowingFunction<T, V, E> andThen(ThrowingFunction<? super R, ? extends V, ? extends E> after) {
        Objects.requireNonNull(after, "after");
        return t -> after.apply((R)this.apply(t));
    }

    @Override
    default public Function<T, R> toUnchecked(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception ex) {
                throw Utils.toUnchecked(ex, exceptionMapper);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> uncheckedOf(ThrowingFunction<T, R, E> throwing) {
        Objects.requireNonNull(throwing, "throwing");
        return (Function)throwing.toUnchecked();
    }

    public static <T, R, E extends Exception> Function<T, R> uncheckedOf(ThrowingFunction<T, R, E> throwing, Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(throwing, "throwing");
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return throwing.toUnchecked(exceptionMapper);
    }

    public static <T, R> ThrowingFunction<T, R, ? extends RuntimeException> of(Function<T, R> function) {
        Objects.requireNonNull(function, "function");
        return function::apply;
    }
}

