/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.Throwing;
import at.itsv.commons.lang.function.throwing.Utils;
import java.util.Objects;
import java.util.function.Function;

public interface ThrowingRunnable<E extends Exception>
extends Throwing<E, Runnable> {
    public void run() throws E;

    @Override
    default public Runnable toUnchecked(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return () -> {
            try {
                this.run();
            }
            catch (Exception ex) {
                throw Utils.toUnchecked(ex, exceptionMapper);
            }
        };
    }

    public static <E extends Exception> Runnable uncheckedOf(ThrowingRunnable<E> throwing) {
        Objects.requireNonNull(throwing, "throwing");
        return (Runnable)throwing.toUnchecked();
    }

    public static <E extends Exception> Runnable uncheckedOf(ThrowingRunnable<E> throwing, Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(throwing, "throwing");
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return throwing.toUnchecked(exceptionMapper);
    }

    public static ThrowingRunnable<? extends RuntimeException> of(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        return runnable::run;
    }
}

