/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.lang.function.throwing;

import at.itsv.commons.lang.function.throwing.Throwing;
import at.itsv.commons.lang.function.throwing.Utils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Exception>
extends Throwing<E, Supplier<T>> {
    public T get() throws E;

    @Override
    default public Supplier<T> toUnchecked(Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return () -> {
            try {
                return this.get();
            }
            catch (Exception ex) {
                throw Utils.toUnchecked(ex, exceptionMapper);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> uncheckedOf(ThrowingSupplier<T, E> throwing) {
        Objects.requireNonNull(throwing, "throwing");
        return (Supplier)throwing.toUnchecked();
    }

    public static <T, E extends Exception> Supplier<T> uncheckedOf(ThrowingSupplier<T, E> throwing, Function<? super Exception, ? extends RuntimeException> exceptionMapper) {
        Objects.requireNonNull(throwing, "throwing");
        Objects.requireNonNull(exceptionMapper, "exceptionMapper");
        return throwing.toUnchecked(exceptionMapper);
    }

    public static <T> ThrowingSupplier<T, ? extends RuntimeException> of(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return supplier::get;
    }
}

