/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.config.jboss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class JBossConfigResourceUtils {
    public static final String CONFIG_DIR_PROPERTY = "jboss.server.config.dir";
    public static final String CONFIG_DIRECTORY = "/sv/";

    private JBossConfigResourceUtils() {
    }

    public static URI getResource(String name) {
        String path = System.getProperty(CONFIG_DIR_PROPERTY) + CONFIG_DIRECTORY + name;
        File file = new File(path);
        if (file.canRead()) {
            return file.toURI();
        }
        URL url = JBossConfigResourceUtils.class.getResource(name);
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Could not convert URL of Base-Resource to URI", ex);
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(String name) {
        URI resource = JBossConfigResourceUtils.getResource(name);
        if (resource == null) {
            return null;
        }
        try {
            return resource.toURL().openStream();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

