/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.config.keyvalue;

import at.itsv.commons.config.keyvalue.EmptyConfiguration;
import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import at.itsv.commons.config.keyvalue.PrefixedConfiguration;
import at.itsv.commons.config.keyvalue.SourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

final class JndiConfiguration
implements KeyValueConfiguration {
    private final Context context;

    JndiConfiguration(Context context) {
        this.context = context;
    }

    @Override
    public KeyValueConfiguration withPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        try {
            if (!prefix.endsWith("/") || this.hasBindings(prefix)) {
                return PrefixedConfiguration.of(this, prefix);
            }
            return new EmptyConfiguration(this);
        }
        catch (NameNotFoundException ex) {
            return new EmptyConfiguration(this);
        }
        catch (NamingException ex) {
            throw new SourceException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBindings(String name) throws NamingException {
        try (NamingEnumeration<Binding> bindings = null;){
            bindings = this.context.listBindings(name);
            boolean bl = bindings != null && bindings.hasMore();
            return bl;
        }
    }

    @Override
    public Optional<String> valueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.lookup(name, String.class, s -> s);
    }

    @Override
    public Optional<Boolean> booleanValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.lookup(name, Boolean.class, Boolean::parseBoolean);
    }

    @Override
    public Optional<Integer> intValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.lookup(name, Integer.class, Integer::parseInt);
    }

    @Override
    public Optional<Long> longValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.lookup(name, Long.class, Long::parseLong);
    }

    @Override
    public Optional<Double> doubleValueOf(String name) {
        Objects.requireNonNull(name, "name");
        return this.lookup(name, Double.class, Double::parseDouble);
    }

    private <T> Optional<T> lookup(String name, Class<T> requestedType, Function<String, T> stringTo) {
        try {
            return Optional.ofNullable(this.context.lookup(name)).flatMap(v -> JndiConfiguration.typed(v, requestedType, stringTo));
        }
        catch (NameNotFoundException ex) {
            return Optional.empty();
        }
        catch (NamingException ex) {
            throw new SourceException(ex);
        }
    }

    private static <T> Optional<T> typed(Object value, Class<T> requestedType, Function<String, T> stringDecoder) {
        if (requestedType.isAssignableFrom(value.getClass())) {
            return Optional.of(value);
        }
        if (value instanceof String) {
            return Optional.of(stringDecoder.apply((String)value));
        }
        return Optional.empty();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.context.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JndiConfiguration other = (JndiConfiguration)obj;
        return this.context.equals(other.context);
    }

    public String toString() {
        return String.format("%s{context=[%s]}", JndiConfiguration.class.getSimpleName(), this.context);
    }
}

