/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.config.keyvalue;

import at.itsv.commons.config.keyvalue.EmptyConfiguration;
import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import at.itsv.commons.config.keyvalue.PrefixedConfiguration;
import at.itsv.commons.lang.function.Functionals;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class MapConfiguration
implements KeyValueConfiguration,
KeyValueConfiguration.StringBased {
    private final Map<String, String> delegate;

    MapConfiguration(Map<String, String> delegate) {
        this.delegate = delegate;
    }

    @Override
    public KeyValueConfiguration withPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        if (this.containsValuesForPrefix(prefix)) {
            return PrefixedConfiguration.of(this, prefix);
        }
        return new EmptyConfiguration(this);
    }

    private boolean containsValuesForPrefix(String prefix) {
        return this.delegate.keySet().stream().anyMatch(Functionals.predicate(prefix::equals).negate().and(key -> key.startsWith(prefix)));
    }

    @Override
    public Optional<String> valueOf(String name) {
        Objects.requireNonNull(name, "name");
        return Optional.ofNullable(this.delegate.get(name));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.delegate.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapConfiguration other = (MapConfiguration)obj;
        return this.delegate.equals(other.delegate);
    }

    public String toString() {
        return String.format("%s{values=[%s]}", MapConfiguration.class.getSimpleName(), this.delegate.entrySet().stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

