/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringdecoding.timestamp;

import at.itsv.commons.lang.Result;
import at.itsv.commons.stringdecoding.timestamp.StringToTimestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

final class ZonedDateTimeFormatterAdapter
implements StringToTimestamp {
    private final DateTimeFormatter delegate;
    private final ZoneId zone;

    ZonedDateTimeFormatterAdapter(DateTimeFormatter delegate) {
        this.delegate = delegate;
        this.zone = Objects.requireNonNull(delegate.getZone(), "delegate.getZone()");
    }

    private Result<ZonedDateTime> parse(DateTimeFormatter formatter, String encoded) {
        return Result.of(() -> formatter.parse(encoded)).flatMap(tempAccessor -> Result.of(() -> ZonedDateTime.from(tempAccessor)).recover(ex -> ZonedDateTime.of(LocalDate.from(tempAccessor), LocalTime.MIN, this.zone)).recover(ex -> ZonedDateTime.of(LocalDate.MIN, LocalTime.from(tempAccessor), this.zone)));
    }

    @Override
    public Instant decode(String encoded) {
        return (Instant)this.parse(this.delegate, encoded).map(ChronoZonedDateTime::toInstant).orElseThrow(ex -> new IllegalArgumentException((Throwable)ex));
    }
}

