/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.concurrent.state;

import at.itsv.commons.concurrent.state.ThreadLocalState;
import at.itsv.commons.concurrent.state.ThreadLocalUnitOfWorkState;
import at.itsv.commons.concurrent.state.UnguardedState;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface State<T>
extends Consumer<T>,
Supplier<T>,
AutoCloseable {
    @Override
    public void accept(T var1);

    @Override
    public T get();

    @Override
    public void close();

    public static <T> State<T> unguarded() {
        return new UnguardedState();
    }

    public static <T> State<T> threadLocal() {
        return new ThreadLocalState(new ThreadLocal());
    }

    public static <T> State<T> threadLocal(Supplier<? extends T> initialValueSupplier) {
        Objects.requireNonNull(initialValueSupplier, "initialValueSupplier");
        return new ThreadLocalState<T>(ThreadLocal.withInitial(initialValueSupplier));
    }

    public static <T> State<T> threadAndUnitOfWorkLocal() {
        return new ThreadLocalUnitOfWorkState(new ThreadLocal());
    }

    public static <T> State<T> threadAndUnitOfWorkLocal(Supplier<? extends T> initialValueSupplier) {
        Objects.requireNonNull(initialValueSupplier, "initialValueSupplier");
        return new ThreadLocalUnitOfWorkState<T>(ThreadLocal.withInitial(initialValueSupplier));
    }
}

