/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.bytes;

import at.itsv.commons.stringconversion.StringConverter;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;

enum Base64BytesConverter implements StringConverter<byte[]>
{
    SINGLETON;

    private static final Charset ENCODED_CHARSET;

    @Override
    public byte[] convertFromString(String encoded) {
        return Base64.decodeBase64((byte[])encoded.getBytes(ENCODED_CHARSET));
    }

    @Override
    public String convertToString(byte[] decoded) {
        return new String(Base64.encodeBase64((byte[])decoded), ENCODED_CHARSET);
    }

    static {
        ENCODED_CHARSET = Charset.forName("US-ASCII");
    }
}

