/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.bytes;

import at.itsv.commons.lang.Arguments;
import at.itsv.commons.stringconversion.StringConverter;
import at.itsv.commons.stringconversion.bytes.Base64BytesConverter;
import at.itsv.commons.stringconversion.bytes.BytesConverter;
import at.itsv.commons.stringconversion.bytes.Encoding;
import at.itsv.commons.stringconversion.bytes.HexBytesConverter;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class BytesConverterFactory {
    private static final ConcurrentMap<Charset, StringConverter<byte[]>> CHARSET_CONVERTERS_CACHE = new ConcurrentHashMap<Charset, StringConverter<byte[]>>(16);

    private BytesConverterFactory() {
    }

    public static StringConverter<byte[]> forCharset(Charset charset) {
        Arguments.require((String)"charset", (Object)charset, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        if (!CHARSET_CONVERTERS_CACHE.containsKey(charset)) {
            CHARSET_CONVERTERS_CACHE.putIfAbsent(charset, new BytesConverter(charset));
        }
        return (StringConverter)CHARSET_CONVERTERS_CACHE.get(charset);
    }

    public static StringConverter<byte[]> forCharset(String charset) {
        return BytesConverterFactory.forCharset(Charset.forName(charset));
    }

    public static StringConverter<byte[]> forEncoding(Encoding encoding) {
        Arguments.require((String)"encoding", (Object)((Object)encoding), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        switch (encoding) {
            case BASE64: {
                return Base64BytesConverter.SINGLETON;
            }
        }
        return HexBytesConverter.SINGLETON;
    }
}

