/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.collections;

import at.itsv.commons.lang.Arguments;
import at.itsv.commons.stringconversion.StringConverter;
import at.itsv.commons.stringconversion.collections.CollectionBuildingStrategy;
import at.itsv.commons.stringconversion.collections.ListCollectionBuildingStrategy;
import at.itsv.commons.stringconversion.collections.PatternSplittingCollectionConverter;
import at.itsv.commons.stringconversion.collections.SetCollectionBuildingStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class CollectionConverterBuilder<T extends Collection<String>> {
    public static final String DEFAULT_SEPARATOR = " ";
    public static final boolean DEFAULT_TRIM = true;
    private final CollectionBuildingStrategy<T> buildingStrategy;
    private final String joinSeparator;
    private final Pattern splitPattern;
    private final boolean trim;

    private CollectionConverterBuilder(CollectionBuildingStrategy<T> buildingStrategy, String joinSeparator, Pattern splitPattern, boolean trim) {
        this.buildingStrategy = buildingStrategy;
        this.joinSeparator = joinSeparator;
        this.splitPattern = splitPattern;
        this.trim = trim;
    }

    public static <T extends Collection<String>> CollectionConverterBuilder<T> forType(Class<? super T> clazz) {
        return new CollectionConverterBuilder<T>(CollectionConverterBuilder.buildingStrategyForType(clazz), DEFAULT_SEPARATOR, null, true);
    }

    public CollectionConverterBuilder<T> withJoinSeparator(String separator) {
        Arguments.require((String)"separator", (Object)separator, (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        return new CollectionConverterBuilder<T>(this.buildingStrategy, separator, this.splitPattern, this.trim);
    }

    public CollectionConverterBuilder<T> withSplitPattern(Pattern pattern) {
        Arguments.require((String)"pattern", (Object)pattern, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        return new CollectionConverterBuilder<T>(this.buildingStrategy, this.joinSeparator, pattern, this.trim);
    }

    public CollectionConverterBuilder<T> withSplitPattern(String pattern) {
        Arguments.require((String)"pattern", (Object)pattern, (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        return new CollectionConverterBuilder<T>(this.buildingStrategy, this.joinSeparator, Pattern.compile(pattern), this.trim);
    }

    public CollectionConverterBuilder<T> withTrimming() {
        return new CollectionConverterBuilder<T>(this.buildingStrategy, this.joinSeparator, this.splitPattern, true);
    }

    public CollectionConverterBuilder<T> withoutTrimming() {
        return new CollectionConverterBuilder<T>(this.buildingStrategy, this.joinSeparator, this.splitPattern, false);
    }

    public StringConverter<T> build() {
        Pattern pattern = this.splitPattern != null ? this.splitPattern : Pattern.compile(this.joinSeparator);
        return new PatternSplittingCollectionConverter<T>(this.buildingStrategy, this.joinSeparator, pattern, this.trim);
    }

    private static <T extends Collection<String>> CollectionBuildingStrategy<T> buildingStrategyForType(Class<? super T> type) {
        if (type.equals(List.class)) {
            return ListCollectionBuildingStrategy.SINGLETON;
        }
        if (type.equals(Set.class) || type.equals(Collection.class)) {
            return SetCollectionBuildingStrategy.SINGLETON;
        }
        throw new IllegalArgumentException("Es werden aktuell nur die folgenden Typen unterst\u00fctzt: " + List.class.getName() + ", " + Set.class.getName() + ", " + Collection.class.getName());
    }
}

