/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.collections;

import at.itsv.commons.lang.Arguments;
import at.itsv.commons.stringconversion.StringConverter;
import at.itsv.commons.stringconversion.collections.CollectionBuildingStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

final class PatternSplittingCollectionConverter<T extends Collection<String>>
implements StringConverter<T> {
    private final CollectionBuildingStrategy<T> buildingStrategy;
    private final String joinSeparator;
    private final Pattern splitPattern;
    private final boolean trim;

    PatternSplittingCollectionConverter(CollectionBuildingStrategy<T> buildingStrategy, String joinSeparator, Pattern splitPattern, boolean trim) {
        this.buildingStrategy = (CollectionBuildingStrategy)Arguments.require((String)"buildingStrategy", buildingStrategy, (Matcher)Matchers.notNullValue());
        this.joinSeparator = (String)Arguments.require((String)"joinSpearator", (Object)joinSeparator, (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.splitPattern = (Pattern)Arguments.require((String)"splitPattern", (Object)splitPattern, (Matcher)Matchers.notNullValue());
        this.trim = trim;
    }

    @Override
    public T convertFromString(String encoded) {
        String[] tokens = this.splitPattern.split(encoded);
        T result = this.buildingStrategy.create(tokens.length);
        for (String token : tokens) {
            if (this.trim) {
                String actual = token.trim();
                if (actual.isEmpty()) continue;
                result.add((String)actual);
                continue;
            }
            result.add((String)token);
        }
        return this.buildingStrategy.makeUnmodifiable(result);
    }

    @Override
    public String convertToString(T decoded) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = decoded.iterator();
        while (iter.hasNext()) {
            String token = (String)iter.next();
            sb.append(token);
            if (!iter.hasNext()) continue;
            sb.append(this.joinSeparator);
        }
        return sb.toString();
    }
}

