/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.date;

import at.itsv.commons.lang.Arguments;
import at.itsv.commons.stringconversion.StringConverter;
import at.itsv.commons.stringconversion.date.StandardDateFormat;
import at.itsv.commons.stringconversion.date.ThreadSafeDateConverter;
import java.util.Date;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class DateConverterFactory {
    private DateConverterFactory() {
    }

    public static StringConverter<Date> forStandardFormat(StandardDateFormat format) {
        Arguments.require((String)"format", (Object)((Object)format), (Matcher)Matchers.notNullValue());
        return new ThreadSafeDateConverter(format.format(), format.timeZone());
    }

    public static StringConverter<Date> forFormat(String format) {
        return new ThreadSafeDateConverter(format, null);
    }

    public static StringConverter<Date> forFormatAndTimeZone(String format, TimeZone timeZone) {
        return new ThreadSafeDateConverter(format, timeZone);
    }
}

