/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.date;

import at.itsv.commons.lang.Arguments;
import at.itsv.commons.stringconversion.StringConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

final class ThreadSafeDateConverter
implements StringConverter<Date> {
    private final ThreadLocal<DateFormat> DATE_FORMAT_HOLDER = new ThreadLocal();
    private final String format;
    private final TimeZone tz;

    private DateFormat dateFormat() {
        DateFormat df = this.DATE_FORMAT_HOLDER.get();
        if (df == null) {
            df = new SimpleDateFormat(this.format);
            if (this.tz != null) {
                df.setTimeZone(this.tz);
            }
            this.DATE_FORMAT_HOLDER.set(df);
        }
        return df;
    }

    ThreadSafeDateConverter(String format, TimeZone tz) {
        this.format = (String)Arguments.require((String)"format", (Object)format, (Matcher)Matchers.notNullValue());
        this.tz = tz;
    }

    @Override
    public Date convertFromString(String encoded) {
        try {
            return this.dateFormat().parse(encoded);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String convertToString(Date decoded) {
        return this.dateFormat().format(decoded);
    }
}

