/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringconversion.primitive;

import at.itsv.commons.stringconversion.StringConverter;
import at.itsv.commons.stringconversion.primitive.BooleanConverter;
import at.itsv.commons.stringconversion.primitive.DoubleConverter;
import at.itsv.commons.stringconversion.primitive.IntegerConverter;
import at.itsv.commons.stringconversion.primitive.LongConverter;

public final class PrimitiveConverterFactory {
    private PrimitiveConverterFactory() {
    }

    public static <T> StringConverter<T> forType(Class<T> type) {
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return IntegerConverter.SINGLETON;
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return LongConverter.SINGLETON;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return BooleanConverter.SINGLETON;
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return DoubleConverter.SINGLETON;
        }
        throw new IllegalArgumentException("Es werden nur folgende Typen unterst\u00fctzt: " + Integer.TYPE.getName() + ", +" + Integer.class.getName() + ", " + Long.TYPE.getName() + ", +" + Long.class.getName() + ", " + Boolean.TYPE.getName() + ", +" + Boolean.class.getName() + ", " + Double.TYPE.getName() + ", +" + Double.class.getName());
    }
}

