/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.commons.stringdecoding.bytes;

import at.itsv.commons.stringdecoding.StringTo;
import at.itsv.commons.stringdecoding.bytes.Base64Decoder;
import at.itsv.commons.stringdecoding.bytes.CharsetDecoder;
import at.itsv.commons.stringdecoding.bytes.HexDecoder;
import java.nio.charset.Charset;
import java.util.Objects;

public interface StringToBytes
extends StringTo<byte[]> {
    public static StringToBytes ofCharset(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return CharsetDecoder.of(charset);
    }

    public static StringToBytes ofCharset(String charset) {
        Objects.requireNonNull(charset, "charset");
        return StringToBytes.ofCharset(Charset.forName(charset));
    }

    public static StringToBytes base64() {
        return Base64Decoder.SINGLETON;
    }

    public static StringToBytes hex() {
        return HexDecoder.SINGLETON;
    }
}

